/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl.metrics;

import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;

public class ProcessingMetrics {
    private static final String NAMESPACE = "zeebe";
    private static final String LABEL_NAME_PARTITION = "partition";
    private static final Histogram BATCH_PROCESSING_DURATION = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("stream_processor_batch_processing_duration")).help("Time spent in batch processing (in seconds)")).buckets(1.0E-4, 0.001, 0.01, 0.1, 0.25, 0.5, 1.0, 2.0).labelNames("partition")).register();
    private static final Histogram BATCH_PROCESSING_COMMANDS = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("stream_processor_batch_processing_commands")).help("Records the distribution of commands in a batch over time")).buckets(1.0, 2.0, 4.0, 8.0, 16.0, 32.0, 64.0, 128.0).labelNames("partition")).register();
    private static final Histogram BATCH_PROCESSING_POST_COMMIT_TASKS = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("stream_processor_batch_processing_post_commit_tasks")).help("Time spent in executing post commit tasks after batch processing (in seconds)")).buckets(1.0E-4, 0.001, 0.01, 0.1, 0.25, 0.5, 1.0, 2.0).labelNames("partition")).register();
    private static final Counter BATCH_PROCESSING_RETRIES = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("stream_processor_batch_processing_retry")).help("Number of times batch processing failed due to reaching batch limit and was retried")).labelNames("partition")).register();
    private final Histogram.Child batchProcessingDuration;
    private final Histogram.Child batchProcessingCommands;
    private final Counter.Child batchProcessingRetries;
    private final Histogram.Child batchProcessingPostCommitTasks;

    public ProcessingMetrics(String partitionIdLabel) {
        this.batchProcessingDuration = (Histogram.Child)BATCH_PROCESSING_DURATION.labels(partitionIdLabel);
        this.batchProcessingCommands = (Histogram.Child)BATCH_PROCESSING_COMMANDS.labels(partitionIdLabel);
        this.batchProcessingRetries = (Counter.Child)BATCH_PROCESSING_RETRIES.labels(partitionIdLabel);
        this.batchProcessingPostCommitTasks = (Histogram.Child)BATCH_PROCESSING_POST_COMMIT_TASKS.labels(partitionIdLabel);
    }

    public Histogram.Timer startBatchProcessingDurationTimer() {
        return this.batchProcessingDuration.startTimer();
    }

    public void observeCommandCount(int commandCount) {
        this.batchProcessingCommands.observe(commandCount);
    }

    public void countRetry() {
        this.batchProcessingRetries.inc();
    }

    public Histogram.Timer startBatchProcessingPostCommitTasksTimer() {
        return this.batchProcessingPostCommitTasks.startTimer();
    }
}

