/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl.metrics;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

public final class ReplayMetrics {
    private static final String LABEL_NAME_PARTITION = "partition";
    private static final String NAMESPACE = "zeebe";
    private static final Counter REPLAY_EVENTS_COUNT = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("replay_events_total")).help("Number of events replayed by the stream processor.")).labelNames("partition")).register();
    private static final Gauge LAST_SOURCE_POSITION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("replay_last_source_position")).help("The last source position the stream processor has replayed.")).labelNames("partition")).register();
    private static final Histogram REPLAY_DURATION = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("replay_event_batch_replay_duration")).help("Time for replay a batch of events (in seconds)")).labelNames("partition")).register();
    private final String partitionIdLabel;

    public ReplayMetrics(int partitionId) {
        this.partitionIdLabel = String.valueOf(partitionId);
    }

    public void event() {
        ((Counter.Child)REPLAY_EVENTS_COUNT.labels(this.partitionIdLabel)).inc();
    }

    public Histogram.Timer startReplayDurationTimer() {
        return ((Histogram.Child)REPLAY_DURATION.labels(this.partitionIdLabel)).startTimer();
    }

    public void setLastSourcePosition(long position) {
        ((Gauge.Child)LAST_SOURCE_POSITION.labels(this.partitionIdLabel)).set(position);
    }
}

