/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl.state;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.stream.api.state.KeyGeneratorControls;
import io.camunda.zeebe.stream.impl.state.NextValueManager;

public final class DbKeyGenerator
implements KeyGeneratorControls {
    private static final long INITIAL_VALUE = 0L;
    private static final String LATEST_KEY = "latestKey";
    private final long keyStartValue;
    private final NextValueManager nextValueManager;

    public DbKeyGenerator(int partitionId, ZeebeDb zeebeDb, TransactionContext transactionContext) {
        this.keyStartValue = Protocol.encodePartitionId(partitionId, 0L);
        this.nextValueManager = new NextValueManager(this.keyStartValue, zeebeDb, transactionContext, ZbColumnFamilies.KEY);
    }

    @Override
    public long nextKey() {
        return this.nextValueManager.getNextValue(LATEST_KEY);
    }

    public long getCurrentKey() {
        return this.nextValueManager.getCurrentValue(LATEST_KEY);
    }

    @Override
    public void setKeyIfHigher(long key) {
        long currentKey = this.nextValueManager.getCurrentValue(LATEST_KEY);
        if (key > currentKey) {
            this.nextValueManager.setValue(LATEST_KEY, key);
        }
    }
}

