/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util;

import io.camunda.zeebe.util.collection.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Either<L, R> {
    public static <L, R> Either<L, R> right(R right) {
        return new Right(right);
    }

    public static <L, R> Either<L, R> left(L left) {
        return new Left(left);
    }

    public static <R> EitherOptional<R> ofOptional(Optional<R> right) {
        return new EitherOptional<R>(right);
    }

    public static <L, R> Collector<Either<L, R>, Tuple<List<L>, List<R>>, Either<List<L>, List<R>>> collector() {
        return Collector.of(() -> new Tuple(new ArrayList(), new ArrayList()), (acc, next) -> next.ifRightOrLeft(right -> ((List)acc.getRight()).add(right), left -> ((List)acc.getLeft()).add(left)), (a, b) -> {
            ((List)a.getLeft()).addAll((Collection)b.getLeft());
            ((List)a.getRight()).addAll((Collection)b.getRight());
            return a;
        }, acc -> {
            if (!((List)acc.getLeft()).isEmpty()) {
                return Either.left((List)acc.getLeft());
            }
            return Either.right((List)acc.getRight());
        }, new Collector.Characteristics[0]);
    }

    public static <L, R> Collector<Either<L, R>, Tuple<Optional<L>, List<R>>, Either<L, List<R>>> collectorFoldingLeft() {
        return Collector.of(() -> new Tuple(Optional.empty(), new ArrayList()), (acc, next) -> next.ifRightOrLeft(right -> ((List)acc.getRight()).add(right), left -> acc.setLeft(((Optional)acc.getLeft()).or(() -> Optional.of(left)))), (a, b) -> {
            if (((Optional)a.getLeft()).isEmpty() && ((Optional)b.getLeft()).isPresent()) {
                a.setLeft((Optional)b.getLeft());
            }
            ((List)a.getRight()).addAll((Collection)b.getRight());
            return a;
        }, acc -> ((Optional)acc.getLeft()).map(Either::left).orElse(Either.right((List)acc.getRight())), new Collector.Characteristics[0]);
    }

    public boolean isRight();

    public boolean isLeft();

    public R get();

    public R getOrElse(R var1);

    public L getLeft();

    public <T> Either<L, T> map(Function<? super R, ? extends T> var1);

    public <T> Either<T, R> mapLeft(Function<? super L, ? extends T> var1);

    public <T> Either<L, T> flatMap(Function<? super R, ? extends Either<L, T>> var1);

    public Either<L, R> thenDo(Consumer<R> var1);

    public void ifRight(Consumer<R> var1);

    public void ifLeft(Consumer<L> var1);

    public void ifRightOrLeft(Consumer<R> var1, Consumer<L> var2);

    public <T> T fold(Function<? super R, ? extends T> var1, Function<? super L, ? extends T> var2);

    public record Right<L, R>(R value) implements Either<L, R>
    {
        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public R get() {
            return this.value;
        }

        @Override
        public R getOrElse(R defaultValue) {
            return this.value;
        }

        @Override
        public L getLeft() {
            throw new NoSuchElementException("Expected a left, but this is right");
        }

        @Override
        public <T> Either<L, T> map(Function<? super R, ? extends T> right) {
            return Either.right(right.apply(this.value));
        }

        @Override
        public <T> Either<T, R> mapLeft(Function<? super L, ? extends T> left) {
            return this;
        }

        @Override
        public <T> Either<L, T> flatMap(Function<? super R, ? extends Either<L, T>> right) {
            return right.apply(this.value);
        }

        @Override
        public Either<L, R> thenDo(Consumer<R> action) {
            action.accept(this.value);
            return this;
        }

        @Override
        public void ifRight(Consumer<R> right) {
            right.accept(this.value);
        }

        @Override
        public void ifLeft(Consumer<L> action) {
        }

        @Override
        public void ifRightOrLeft(Consumer<R> rightAction, Consumer<L> leftAction) {
            rightAction.accept(this.value);
        }

        @Override
        public <T> T fold(Function<? super R, ? extends T> rightFn, Function<? super L, ? extends T> leftFn) {
            return rightFn.apply(this.value);
        }
    }

    public record Left<L, R>(L value) implements Either<L, R>
    {
        @Override
        public boolean isRight() {
            return false;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public R get() {
            throw new NoSuchElementException("Expected a right, but this is left");
        }

        @Override
        public R getOrElse(R defaultValue) {
            return defaultValue;
        }

        @Override
        public L getLeft() {
            return this.value;
        }

        @Override
        public <T> Either<L, T> map(Function<? super R, ? extends T> right) {
            return this;
        }

        @Override
        public <T> Either<T, R> mapLeft(Function<? super L, ? extends T> left) {
            return Either.left(left.apply(this.value));
        }

        @Override
        public <T> Either<L, T> flatMap(Function<? super R, ? extends Either<L, T>> right) {
            return this;
        }

        @Override
        public Either<L, R> thenDo(Consumer<R> action) {
            return this;
        }

        @Override
        public void ifRight(Consumer<R> right) {
        }

        @Override
        public void ifLeft(Consumer<L> action) {
            action.accept(this.value);
        }

        @Override
        public void ifRightOrLeft(Consumer<R> rightAction, Consumer<L> leftAction) {
            leftAction.accept(this.value);
        }

        @Override
        public <T> T fold(Function<? super R, ? extends T> rightFn, Function<? super L, ? extends T> leftFn) {
            return leftFn.apply(this.value);
        }
    }

    public record EitherOptional<R>(Optional<R> right) {
        public <L> Either<L, R> orElse(L left) {
            return this.right.map(Either::right).orElse(Either.left(left));
        }
    }
}

