/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.error;

import io.camunda.zeebe.util.error.FatalErrorHandler;
import org.slf4j.Logger;

public final class VirtualMachineErrorHandler
implements FatalErrorHandler,
Thread.UncaughtExceptionHandler {
    private static final int EXIT_CODE = 156;
    private final Logger log;

    VirtualMachineErrorHandler(Logger log) {
        this.log = log;
    }

    @Override
    public void handleError(Throwable e) {
        if (e instanceof VirtualMachineError) {
            this.tryLogging(e);
            System.exit(156);
        }
    }

    private void tryLogging(Throwable e) {
        try {
            if (e instanceof OutOfMemoryError) {
                this.log.error("Out of memory, exiting now because we can't recover from OOM. Consider adjusting memory limits.", e);
            } else {
                this.log.error("Shutting down because we can't recover from JVM errors. Consider restarting this broker if it is a temporary issue.", e);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void uncaughtException(Thread t2, Throwable e) {
        this.handleError(e);
    }
}

