/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.jar;

import io.camunda.zeebe.util.CheckedRunnable;
import java.util.concurrent.Callable;
import org.agrona.LangUtil;

public final class ThreadContextUtil {
    public static void runWithClassLoader(Runnable runnable, ClassLoader classLoader) {
        try {
            ThreadContextUtil.runCheckedWithClassLoader(runnable::run, classLoader);
        }
        catch (Exception e) {
            LangUtil.rethrowUnchecked(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runCheckedWithClassLoader(CheckedRunnable runnable, ClassLoader classLoader) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(classLoader);
            runnable.run();
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V callWithClassLoader(Callable<V> callable, ClassLoader classLoader) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(classLoader);
            V v = callable.call();
            return v;
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }
}

