/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.logging;

import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class ThrottledLogger
implements Logger {
    private long lastLogTime = 0L;
    private final Logger log;
    private final long intervalMillis;

    public ThrottledLogger(Logger log, Duration interval) {
        this.log = log;
        this.intervalMillis = interval.toMillis();
    }

    @Override
    public String getName() {
        return this.log.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    @Override
    public void trace(String s2) {
        this.checkAndLog(() -> this.log.trace(s2));
    }

    @Override
    public void trace(String s2, Object o) {
        this.checkAndLog(() -> this.log.trace(s2, o));
    }

    @Override
    public void trace(String s2, Object o, Object o1) {
        this.checkAndLog(() -> this.log.trace(s2, o, o1));
    }

    @Override
    public void trace(String s2, Object ... objects) {
        this.checkAndLog(() -> this.log.trace(s2, objects));
    }

    @Override
    public void trace(String s2, Throwable throwable) {
        this.checkAndLog(() -> this.log.trace(s2, throwable));
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.log.isTraceEnabled(marker);
    }

    @Override
    public void trace(Marker marker, String s2) {
        this.checkAndLog(() -> this.log.trace(marker, s2));
    }

    @Override
    public void trace(Marker marker, String s2, Object o) {
        this.checkAndLog(() -> this.log.trace(marker, s2, o));
    }

    @Override
    public void trace(Marker marker, String s2, Object o, Object o1) {
        this.checkAndLog(() -> this.log.trace(marker, s2, o, o1));
    }

    @Override
    public void trace(Marker marker, String s2, Object ... objects) {
        this.checkAndLog(() -> this.log.trace(marker, s2, objects));
    }

    @Override
    public void trace(Marker marker, String s2, Throwable throwable) {
        this.checkAndLog(() -> this.log.trace(marker, s2, throwable));
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public void debug(String s2) {
        this.checkAndLog(() -> this.log.debug(s2));
    }

    @Override
    public void debug(String s2, Object o) {
        this.checkAndLog(() -> this.log.debug(s2, o));
    }

    @Override
    public void debug(String s2, Object o, Object o1) {
        this.checkAndLog(() -> this.log.debug(s2, o, o1));
    }

    @Override
    public void debug(String s2, Object ... objects) {
        this.checkAndLog(() -> this.log.debug(s2, objects));
    }

    @Override
    public void debug(String s2, Throwable throwable) {
        this.checkAndLog(() -> this.log.debug(s2, throwable));
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.log.isDebugEnabled(marker);
    }

    @Override
    public void debug(Marker marker, String s2) {
        this.checkAndLog(() -> this.log.debug(marker, s2));
    }

    @Override
    public void debug(Marker marker, String s2, Object o) {
        this.checkAndLog(() -> this.log.debug(marker, s2, o));
    }

    @Override
    public void debug(Marker marker, String s2, Object o, Object o1) {
        this.checkAndLog(() -> this.log.debug(marker, s2, o, o1));
    }

    @Override
    public void debug(Marker marker, String s2, Object ... objects) {
        this.checkAndLog(() -> this.log.debug(marker, s2, objects));
    }

    @Override
    public void debug(Marker marker, String s2, Throwable throwable) {
        this.checkAndLog(() -> this.log.debug(marker, s2, throwable));
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public void info(String s2) {
        this.checkAndLog(() -> this.log.info(s2));
    }

    @Override
    public void info(String s2, Object o) {
        this.checkAndLog(() -> this.log.info(s2, o));
    }

    @Override
    public void info(String s2, Object o, Object o1) {
        this.checkAndLog(() -> this.log.info(s2, o, o1));
    }

    @Override
    public void info(String s2, Object ... objects) {
        this.checkAndLog(() -> this.log.info(s2, objects));
    }

    @Override
    public void info(String s2, Throwable throwable) {
        this.checkAndLog(() -> this.log.info(s2, throwable));
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.log.isInfoEnabled(marker);
    }

    @Override
    public void info(Marker marker, String s2) {
        this.checkAndLog(() -> this.log.info(marker, s2));
    }

    @Override
    public void info(Marker marker, String s2, Object o) {
        this.checkAndLog(() -> this.log.info(marker, s2, o));
    }

    @Override
    public void info(Marker marker, String s2, Object o, Object o1) {
        this.checkAndLog(() -> this.log.info(marker, s2, o, o1));
    }

    @Override
    public void info(Marker marker, String s2, Object ... objects) {
        this.checkAndLog(() -> this.log.info(marker, s2, objects));
    }

    @Override
    public void info(Marker marker, String s2, Throwable throwable) {
        this.checkAndLog(() -> this.log.info(marker, s2, throwable));
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    @Override
    public void warn(String s2) {
        this.checkAndLog(() -> this.log.warn(s2));
    }

    @Override
    public void warn(String s2, Object o) {
        this.checkAndLog(() -> this.log.warn(s2, o));
    }

    @Override
    public void warn(String s2, Object ... objects) {
        this.checkAndLog(() -> this.log.warn(s2, objects));
    }

    @Override
    public void warn(String s2, Object o, Object o1) {
        this.checkAndLog(() -> this.log.warn(s2, o, o1));
    }

    @Override
    public void warn(String s2, Throwable throwable) {
        this.checkAndLog(() -> this.log.warn(s2, throwable));
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.log.isWarnEnabled(marker);
    }

    @Override
    public void warn(Marker marker, String s2) {
        this.checkAndLog(() -> this.log.warn(marker, s2));
    }

    @Override
    public void warn(Marker marker, String s2, Object o) {
        this.checkAndLog(() -> this.log.warn(marker, s2, o));
    }

    @Override
    public void warn(Marker marker, String s2, Object o, Object o1) {
        this.checkAndLog(() -> this.log.warn(marker, s2, o, o1));
    }

    @Override
    public void warn(Marker marker, String s2, Object ... objects) {
        this.checkAndLog(() -> this.log.warn(marker, s2, objects));
    }

    @Override
    public void warn(Marker marker, String s2, Throwable throwable) {
        this.checkAndLog(() -> this.log.warn(marker, s2, throwable));
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    @Override
    public void error(String s2) {
        this.checkAndLog(() -> this.log.error(s2));
    }

    @Override
    public void error(String s2, Object o) {
        this.checkAndLog(() -> this.log.error(s2, o));
    }

    @Override
    public void error(String s2, Object o, Object o1) {
        this.checkAndLog(() -> this.log.error(s2, o, o1));
    }

    @Override
    public void error(String s2, Object ... objects) {
        this.checkAndLog(() -> this.log.error(s2, objects));
    }

    @Override
    public void error(String s2, Throwable throwable) {
        this.checkAndLog(() -> this.log.error(s2, throwable));
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.log.isErrorEnabled(marker);
    }

    @Override
    public void error(Marker marker, String s2) {
        this.checkAndLog(() -> this.log.error(marker, s2));
    }

    @Override
    public void error(Marker marker, String s2, Object o) {
        this.checkAndLog(() -> this.log.error(marker, s2, o));
    }

    @Override
    public void error(Marker marker, String s2, Object o, Object o1) {
        this.checkAndLog(() -> this.log.error(marker, s2, o, o1));
    }

    @Override
    public void error(Marker marker, String s2, Object ... objects) {
        this.checkAndLog(() -> this.log.error(marker, s2, objects));
    }

    @Override
    public void error(Marker marker, String s2, Throwable throwable) {
        this.checkAndLog(() -> this.log.error(marker, s2, throwable));
    }

    private void checkAndLog(Runnable logger) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastLogTime >= this.intervalMillis) {
            logger.run();
            this.lastLogTime = currentTime;
        }
    }
}

