/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.nativex.feature;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.regex.Pattern;
import org.graalvm.nativeimage.hosted.Feature;
import org.springframework.aot.nativex.feature.ThrowawayClassLoader;

class PreComputeFieldFeature
implements Feature {
    private static Pattern[] patterns = new Pattern[]{Pattern.compile(Pattern.quote("org.springframework.core.NativeDetector#inNativeImage")), Pattern.compile(Pattern.quote("org.springframework.cglib.core.AbstractClassGenerator#inNativeImage")), Pattern.compile(Pattern.quote("org.springframework.aot.AotDetector#inNativeImage")), Pattern.compile(Pattern.quote("org.springframework.") + ".*#.*Present"), Pattern.compile(Pattern.quote("org.springframework.") + ".*#.*PRESENT"), Pattern.compile(Pattern.quote("reactor.core.") + ".*#.*Available"), Pattern.compile(Pattern.quote("org.apache.commons.logging.LogAdapter") + "#.*Present")};
    private final ThrowawayClassLoader throwawayClassLoader = new ThrowawayClassLoader(PreComputeFieldFeature.class.getClassLoader());

    PreComputeFieldFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        access.registerSubtypeReachabilityHandler(this::iterateFields, Object.class);
    }

    private void iterateFields(Feature.DuringAnalysisAccess access, Class<?> subtype) {
        try {
            for (Field field2 : subtype.getDeclaredFields()) {
                int modifiers = field2.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || field2.isEnumConstant() || field2.getType() != Boolean.TYPE && field2.getType() != Boolean.class) continue;
                String fieldIdentifier = field2.getDeclaringClass().getName() + "#" + field2.getName();
                for (Pattern pattern : patterns) {
                    if (!pattern.matcher(fieldIdentifier).matches()) continue;
                    try {
                        Object fieldValue = this.provideFieldValue(field2);
                        access.registerFieldValueTransformer(field2, (receiver, originalValue) -> fieldValue);
                        System.out.println("Field " + fieldIdentifier + " set to " + fieldValue + " at build time");
                    }
                    catch (Throwable ex) {
                        System.out.println("Field " + fieldIdentifier + " will be evaluated at runtime due to this error during build time evaluation: " + ex.getMessage());
                    }
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private Object provideFieldValue(Field field2) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Class<?> throwawayClass = this.throwawayClassLoader.loadClass(field2.getDeclaringClass().getName());
        Field throwawayField = throwawayClass.getDeclaredField(field2.getName());
        throwawayField.setAccessible(true);
        return throwawayField.get(null);
    }
}

