/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.aot.AutowiredElementResolver;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.function.ThrowingConsumer;

public final class AutowiredFieldValueResolver
extends AutowiredElementResolver {
    private final String fieldName;
    private final boolean required;
    @Nullable
    private final String shortcut;

    private AutowiredFieldValueResolver(String fieldName, boolean required, @Nullable String shortcut) {
        Assert.hasText(fieldName, "'fieldName' must not be empty");
        this.fieldName = fieldName;
        this.required = required;
        this.shortcut = shortcut;
    }

    public static AutowiredFieldValueResolver forField(String fieldName) {
        return new AutowiredFieldValueResolver(fieldName, false, null);
    }

    public static AutowiredFieldValueResolver forRequiredField(String fieldName) {
        return new AutowiredFieldValueResolver(fieldName, true, null);
    }

    public AutowiredFieldValueResolver withShortcut(String beanName) {
        return new AutowiredFieldValueResolver(this.fieldName, this.required, beanName);
    }

    public <T> void resolve(RegisteredBean registeredBean, ThrowingConsumer<T> action) {
        Assert.notNull((Object)registeredBean, "'registeredBean' must not be null");
        Assert.notNull(action, "'action' must not be null");
        T resolved = this.resolve(registeredBean);
        if (resolved != null) {
            action.accept(resolved);
        }
    }

    @Nullable
    public <T> T resolve(RegisteredBean registeredBean, Class<T> requiredType) {
        Object value = this.resolveObject(registeredBean);
        Assert.isInstanceOf(requiredType, value);
        return (T)value;
    }

    @Nullable
    public <T> T resolve(RegisteredBean registeredBean) {
        return (T)this.resolveObject(registeredBean);
    }

    @Nullable
    public Object resolveObject(RegisteredBean registeredBean) {
        Assert.notNull((Object)registeredBean, "'registeredBean' must not be null");
        return this.resolveValue(registeredBean, this.getField(registeredBean));
    }

    public void resolveAndSet(RegisteredBean registeredBean, Object instance) {
        Assert.notNull((Object)registeredBean, "'registeredBean' must not be null");
        Assert.notNull(instance, "'instance' must not be null");
        Field field2 = this.getField(registeredBean);
        Object resolved = this.resolveValue(registeredBean, field2);
        if (resolved != null) {
            ReflectionUtils.makeAccessible(field2);
            ReflectionUtils.setField(field2, instance, resolved);
        }
    }

    @Nullable
    private Object resolveValue(RegisteredBean registeredBean, Field field2) {
        String beanName = registeredBean.getBeanName();
        Class<?> beanClass = registeredBean.getBeanClass();
        ConfigurableListableBeanFactory beanFactory = registeredBean.getBeanFactory();
        DependencyDescriptor descriptor = new DependencyDescriptor(field2, this.required);
        descriptor.setContainingClass(beanClass);
        if (this.shortcut != null) {
            descriptor = new AutowiredElementResolver.ShortcutDependencyDescriptor(descriptor, this.shortcut);
        }
        LinkedHashSet<String> autowiredBeanNames = new LinkedHashSet<String>(1);
        TypeConverter typeConverter = beanFactory.getTypeConverter();
        try {
            Assert.isInstanceOf(AutowireCapableBeanFactory.class, beanFactory);
            Object value = ((AutowireCapableBeanFactory)beanFactory).resolveDependency(descriptor, beanName, autowiredBeanNames, typeConverter);
            this.registerDependentBeans(beanFactory, beanName, autowiredBeanNames);
            return value;
        }
        catch (BeansException ex) {
            throw new UnsatisfiedDependencyException(null, beanName, new InjectionPoint(field2), ex);
        }
    }

    private Field getField(RegisteredBean registeredBean) {
        Field field2 = ReflectionUtils.findField(registeredBean.getBeanClass(), this.fieldName);
        Assert.notNull((Object)field2, () -> "No field '" + this.fieldName + "' found on " + registeredBean.getBeanClass().getName());
        return field2;
    }
}

