/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.function.Function;
import org.springframework.beans.BeanUtils;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public abstract class AbstractCompositeHealthContributorConfiguration<C, I extends C, B> {
    private final Function<B, I> indicatorFactory;

    @Deprecated(since="3.0.0", forRemoval=true)
    protected AbstractCompositeHealthContributorConfiguration() {
        this.indicatorFactory = new ReflectionIndicatorFactory(ResolvableType.forClass(AbstractCompositeHealthContributorConfiguration.class, this.getClass()));
    }

    protected AbstractCompositeHealthContributorConfiguration(Function<B, I> indicatorFactory) {
        this.indicatorFactory = indicatorFactory;
    }

    protected final C createContributor(Map<String, B> beans2) {
        Assert.notEmpty(beans2, "Beans must not be empty");
        if (beans2.size() == 1) {
            return (C)this.createIndicator(beans2.values().iterator().next());
        }
        return this.createComposite(beans2);
    }

    protected abstract C createComposite(Map<String, B> var1);

    protected I createIndicator(B bean2) {
        return this.indicatorFactory.apply(bean2);
    }

    private class ReflectionIndicatorFactory
    implements Function<B, I> {
        private final Class<?> indicatorType;
        private final Class<?> beanType;

        ReflectionIndicatorFactory(ResolvableType type) {
            this.indicatorType = type.resolveGeneric(1);
            this.beanType = type.resolveGeneric(2);
        }

        @Override
        public I apply(B bean2) {
            try {
                return BeanUtils.instantiateClass(this.getConstructor(), bean2);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to create health indicator %s for bean type %s".formatted(this.indicatorType, this.beanType), ex);
            }
        }

        private Constructor<I> getConstructor() throws NoSuchMethodException {
            return this.indicatorType.getDeclaredConstructor(this.beanType);
        }
    }
}

