/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.amqp;

import com.rabbitmq.client.ConnectionFactory;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.metrics.amqp.RabbitMetrics;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

class RabbitConnectionFactoryMetricsPostProcessor
implements BeanPostProcessor,
Ordered {
    private static final String CONNECTION_FACTORY_SUFFIX = "connectionFactory";
    private final ApplicationContext context;
    private volatile MeterRegistry meterRegistry;

    RabbitConnectionFactoryMetricsPostProcessor(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) {
        if (bean2 instanceof AbstractConnectionFactory) {
            AbstractConnectionFactory connectionFactory = (AbstractConnectionFactory)bean2;
            this.bindConnectionFactoryToRegistry(this.getMeterRegistry(), beanName, connectionFactory);
        }
        return bean2;
    }

    private void bindConnectionFactoryToRegistry(MeterRegistry registry, String beanName, AbstractConnectionFactory connectionFactory) {
        ConnectionFactory rabbitConnectionFactory = connectionFactory.getRabbitConnectionFactory();
        String connectionFactoryName = this.getConnectionFactoryName(beanName);
        new RabbitMetrics(rabbitConnectionFactory, (Iterable<Tag>)Tags.of((String)"name", (String)connectionFactoryName)).bindTo(registry);
    }

    private String getConnectionFactoryName(String beanName) {
        if (beanName.length() > CONNECTION_FACTORY_SUFFIX.length() && StringUtils.endsWithIgnoreCase(beanName, CONNECTION_FACTORY_SUFFIX)) {
            return beanName.substring(0, beanName.length() - CONNECTION_FACTORY_SUFFIX.length());
        }
        return beanName;
    }

    private MeterRegistry getMeterRegistry() {
        if (this.meterRegistry == null) {
            this.meterRegistry = this.context.getBean(MeterRegistry.class);
        }
        return this.meterRegistry;
    }

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

