/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation.web.client;

import io.micrometer.common.KeyValues;
import io.micrometer.core.instrument.Tag;
import org.springframework.boot.actuate.metrics.web.client.RestTemplateExchangeTagsProvider;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.observation.ClientRequestObservationContext;
import org.springframework.http.client.observation.ClientRequestObservationConvention;

class ClientHttpObservationConventionAdapter
implements ClientRequestObservationConvention {
    private final String metricName;
    private final RestTemplateExchangeTagsProvider tagsProvider;

    ClientHttpObservationConventionAdapter(String metricName, RestTemplateExchangeTagsProvider tagsProvider) {
        this.metricName = metricName;
        this.tagsProvider = tagsProvider;
    }

    public KeyValues getLowCardinalityKeyValues(ClientRequestObservationContext context) {
        Iterable<Tag> tags = this.tagsProvider.getTags(context.getUriTemplate(), (HttpRequest)context.getCarrier(), (ClientHttpResponse)context.getResponse());
        return KeyValues.of(tags, Tag::getKey, Tag::getValue);
    }

    public KeyValues getHighCardinalityKeyValues(ClientRequestObservationContext context) {
        return KeyValues.empty();
    }

    public String getName() {
        return this.metricName;
    }
}

