/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation.web.client;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationProperties;
import org.springframework.boot.actuate.autoconfigure.observation.web.client.ClientObservationConventionAdapter;
import org.springframework.boot.actuate.metrics.web.reactive.client.ObservationWebClientCustomizer;
import org.springframework.boot.actuate.metrics.web.reactive.client.WebClientExchangeTagsProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.ClientRequestObservationConvention;
import org.springframework.web.reactive.function.client.DefaultClientRequestObservationConvention;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={WebClient.class})
class WebClientObservationConfiguration {
    WebClientObservationConfiguration() {
    }

    @Bean
    ObservationWebClientCustomizer observationWebClientCustomizer(ObservationRegistry observationRegistry, ObjectProvider<ClientRequestObservationConvention> customConvention, ObservationProperties observationProperties, ObjectProvider<WebClientExchangeTagsProvider> tagsProvider, MetricsProperties metricsProperties) {
        String name = WebClientObservationConfiguration.observationName(observationProperties, metricsProperties);
        ClientRequestObservationConvention observationConvention = WebClientObservationConfiguration.createConvention(customConvention.getIfAvailable(), tagsProvider.getIfAvailable(), name);
        return new ObservationWebClientCustomizer(observationRegistry, observationConvention);
    }

    private static ClientRequestObservationConvention createConvention(ClientRequestObservationConvention customConvention, WebClientExchangeTagsProvider tagsProvider, String name) {
        if (customConvention != null) {
            return customConvention;
        }
        if (tagsProvider != null) {
            return new ClientObservationConventionAdapter(name, tagsProvider);
        }
        return new DefaultClientRequestObservationConvention(name);
    }

    private static String observationName(ObservationProperties observationProperties, MetricsProperties metricsProperties) {
        String metricName = metricsProperties.getWeb().getClient().getRequest().getMetricName();
        String observationName = observationProperties.getHttp().getClient().getRequests().getName();
        return observationName != null ? observationName : metricName;
    }
}

