/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing.prometheus;

import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import io.prometheus.client.exemplars.tracer.common.SpanContextSupplier;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.export.prometheus.PrometheusMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.boot.actuate.autoconfigure.tracing.MicrometerTracingAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.util.function.SingletonSupplier;

@AutoConfiguration(before={PrometheusMetricsExportAutoConfiguration.class}, after={MicrometerTracingAutoConfiguration.class})
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnClass(value={Tracer.class, SpanContextSupplier.class})
@ConditionalOnEnabledTracing
public class PrometheusExemplarsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    SpanContextSupplier spanContextSupplier(ObjectProvider<Tracer> tracerProvider) {
        return new LazyTracingSpanContextSupplier(tracerProvider);
    }

    static class LazyTracingSpanContextSupplier
    implements SpanContextSupplier {
        private final SingletonSupplier<Tracer> tracer = SingletonSupplier.of(tracerProvider::getObject);

        LazyTracingSpanContextSupplier(ObjectProvider<Tracer> tracerProvider) {
        }

        @Override
        public String getTraceId() {
            Span currentSpan = this.currentSpan();
            return currentSpan != null ? currentSpan.context().traceId() : null;
        }

        @Override
        public String getSpanId() {
            Span currentSpan = this.currentSpan();
            return currentSpan != null ? currentSpan.context().spanId() : null;
        }

        @Override
        public boolean isSampled() {
            Span currentSpan = this.currentSpan();
            if (currentSpan == null) {
                return false;
            }
            Boolean sampled = currentSpan.context().sampled();
            return sampled != null && sampled != false;
        }

        private Span currentSpan() {
            return this.tracer.obtain().currentSpan();
        }
    }
}

