/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing.zipkin;

import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.PropertiesZipkinConnectionDetails;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinConnectionDetails;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinProperties;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinRestTemplateBuilderCustomizer;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinRestTemplateSender;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinWebClientBuilderCustomizer;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinWebClientSender;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.brave.ZipkinSpanHandler;
import zipkin2.reporter.urlconnection.URLConnectionSender;

class ZipkinConfigurations {
    ZipkinConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ZipkinSpanExporter.class})
    static class OpenTelemetryConfiguration {
        OpenTelemetryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={Sender.class})
        ZipkinSpanExporter zipkinSpanExporter(BytesEncoder<Span> encoder, Sender sender) {
            return ZipkinSpanExporter.builder().setEncoder(encoder).setSender(sender).build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ZipkinSpanHandler.class})
    static class BraveConfiguration {
        BraveConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={Reporter.class})
        ZipkinSpanHandler zipkinSpanHandler(Reporter<Span> spanReporter) {
            return (ZipkinSpanHandler)ZipkinSpanHandler.newBuilder(spanReporter).build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class ReporterConfiguration {
        ReporterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Reporter.class})
        @ConditionalOnBean(value={Sender.class})
        AsyncReporter<Span> spanReporter(Sender sender, BytesEncoder<Span> encoder) {
            return AsyncReporter.builder((Sender)sender).build(encoder);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={WebClient.class})
    @EnableConfigurationProperties(value={ZipkinProperties.class})
    static class WebClientSenderConfiguration {
        WebClientSenderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Sender.class})
        ZipkinWebClientSender webClientSender(ZipkinProperties properties, ObjectProvider<ZipkinWebClientBuilderCustomizer> customizers, ObjectProvider<ZipkinConnectionDetails> connectionDetailsProvider) {
            ZipkinConnectionDetails connectionDetails = connectionDetailsProvider.getIfAvailable(() -> new PropertiesZipkinConnectionDetails(properties));
            WebClient.Builder builder = WebClient.builder();
            customizers.orderedStream().forEach(customizer2 -> customizer2.customize(builder));
            return new ZipkinWebClientSender(connectionDetails.getSpanEndpoint(), builder.build());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RestTemplate.class})
    @EnableConfigurationProperties(value={ZipkinProperties.class})
    static class RestTemplateSenderConfiguration {
        RestTemplateSenderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Sender.class})
        ZipkinRestTemplateSender restTemplateSender(ZipkinProperties properties, ObjectProvider<ZipkinRestTemplateBuilderCustomizer> customizers, ObjectProvider<ZipkinConnectionDetails> connectionDetailsProvider) {
            ZipkinConnectionDetails connectionDetails = connectionDetailsProvider.getIfAvailable(() -> new PropertiesZipkinConnectionDetails(properties));
            RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[0]).setConnectTimeout(properties.getConnectTimeout()).setReadTimeout(properties.getReadTimeout());
            restTemplateBuilder = this.applyCustomizers(restTemplateBuilder, customizers);
            return new ZipkinRestTemplateSender(connectionDetails.getSpanEndpoint(), restTemplateBuilder.build());
        }

        private RestTemplateBuilder applyCustomizers(RestTemplateBuilder restTemplateBuilder, ObjectProvider<ZipkinRestTemplateBuilderCustomizer> customizers) {
            Iterable orderedCustomizers = () -> customizers.orderedStream().iterator();
            RestTemplateBuilder currentBuilder = restTemplateBuilder;
            for (ZipkinRestTemplateBuilderCustomizer customizer2 : orderedCustomizers) {
                currentBuilder = customizer2.customize(currentBuilder);
            }
            return currentBuilder;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={URLConnectionSender.class})
    @EnableConfigurationProperties(value={ZipkinProperties.class})
    static class UrlConnectionSenderConfiguration {
        UrlConnectionSenderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Sender.class})
        URLConnectionSender urlConnectionSender(ZipkinProperties properties, ObjectProvider<ZipkinConnectionDetails> connectionDetailsProvider) {
            ZipkinConnectionDetails connectionDetails = connectionDetailsProvider.getIfAvailable(() -> new PropertiesZipkinConnectionDetails(properties));
            URLConnectionSender.Builder builder = URLConnectionSender.newBuilder();
            builder.connectTimeout((int)properties.getConnectTimeout().toMillis());
            builder.readTimeout((int)properties.getReadTimeout().toMillis());
            builder.endpoint(connectionDetails.getSpanEndpoint());
            return builder.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={UrlConnectionSenderConfiguration.class, WebClientSenderConfiguration.class, RestTemplateSenderConfiguration.class})
    static class SenderConfiguration {
        SenderConfiguration() {
        }
    }
}

