/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.data.redis;

import org.springframework.boot.actuate.data.redis.RedisHealth;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.util.Assert;

public class RedisHealthIndicator
extends AbstractHealthIndicator {
    private final RedisConnectionFactory redisConnectionFactory;

    public RedisHealthIndicator(RedisConnectionFactory connectionFactory) {
        super("Redis health check failed");
        Assert.notNull((Object)connectionFactory, "ConnectionFactory must not be null");
        this.redisConnectionFactory = connectionFactory;
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        RedisConnection connection = RedisConnectionUtils.getConnection((RedisConnectionFactory)this.redisConnectionFactory);
        try {
            this.doHealthCheck(builder, connection);
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisConnectionFactory);
        }
    }

    private void doHealthCheck(Health.Builder builder, RedisConnection connection) {
        if (connection instanceof RedisClusterConnection) {
            RedisClusterConnection clusterConnection = (RedisClusterConnection)connection;
            RedisHealth.fromClusterInfo(builder, clusterConnection.clusterGetClusterInfo());
        } else {
            RedisHealth.up(builder, connection.serverCommands().info());
        }
    }
}

