/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.ssl;

import java.util.Map;
import java.util.function.Function;
import org.springframework.boot.autoconfigure.ssl.PropertiesSslBundle;
import org.springframework.boot.autoconfigure.ssl.SslBundleProperties;
import org.springframework.boot.autoconfigure.ssl.SslBundleRegistrar;
import org.springframework.boot.autoconfigure.ssl.SslProperties;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundleRegistry;

class SslPropertiesBundleRegistrar
implements SslBundleRegistrar {
    private final SslProperties.Bundles properties;

    SslPropertiesBundleRegistrar(SslProperties properties) {
        this.properties = properties.getBundle();
    }

    @Override
    public void registerBundles(SslBundleRegistry registry) {
        this.registerBundles(registry, this.properties.getPem(), PropertiesSslBundle::get);
        this.registerBundles(registry, this.properties.getJks(), PropertiesSslBundle::get);
    }

    private <P extends SslBundleProperties> void registerBundles(SslBundleRegistry registry, Map<String, P> properties, Function<P, SslBundle> bundleFactory) {
        properties.forEach((bundleName, bundleProperties) -> registry.registerBundle((String)bundleName, (SslBundle)bundleFactory.apply(bundleProperties)));
    }
}

