/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl;

import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.boot.ssl.DefaultSslManagerBundle;
import org.springframework.boot.ssl.SslBundleKey;
import org.springframework.boot.ssl.SslStoreBundle;
import org.springframework.util.Assert;

public interface SslManagerBundle {
    default public KeyManager[] getKeyManagers() {
        return this.getKeyManagerFactory().getKeyManagers();
    }

    public KeyManagerFactory getKeyManagerFactory();

    default public TrustManager[] getTrustManagers() {
        return this.getTrustManagerFactory().getTrustManagers();
    }

    public TrustManagerFactory getTrustManagerFactory();

    default public SSLContext createSslContext(String protocol) {
        try {
            SSLContext sslContext = SSLContext.getInstance(protocol);
            sslContext.init(this.getKeyManagers(), this.getTrustManagers(), null);
            return sslContext;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not load SSL context: " + ex.getMessage(), ex);
        }
    }

    public static SslManagerBundle of(final KeyManagerFactory keyManagerFactory, final TrustManagerFactory trustManagerFactory) {
        Assert.notNull((Object)keyManagerFactory, "KeyManagerFactory must not be null");
        Assert.notNull((Object)trustManagerFactory, "TrustManagerFactory must not be null");
        return new SslManagerBundle(){

            @Override
            public KeyManagerFactory getKeyManagerFactory() {
                return keyManagerFactory;
            }

            @Override
            public TrustManagerFactory getTrustManagerFactory() {
                return trustManagerFactory;
            }
        };
    }

    public static SslManagerBundle from(SslStoreBundle storeBundle, SslBundleKey key) {
        return new DefaultSslManagerBundle(storeBundle, key);
    }
}

