/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.client;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.io.SocketConfig;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.boot.web.client.ClientHttpRequestFactorySettings;
import org.springframework.http.client.AbstractClientHttpRequestFactoryWrapper;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public final class ClientHttpRequestFactories {
    static final String APACHE_HTTP_CLIENT_CLASS = "org.apache.hc.client5.http.impl.classic.HttpClients";
    private static final boolean APACHE_HTTP_CLIENT_PRESENT = ClassUtils.isPresent("org.apache.hc.client5.http.impl.classic.HttpClients", null);
    static final String OKHTTP_CLIENT_CLASS = "okhttp3.OkHttpClient";
    private static final boolean OKHTTP_CLIENT_PRESENT = ClassUtils.isPresent("okhttp3.OkHttpClient", null);

    private ClientHttpRequestFactories() {
    }

    public static ClientHttpRequestFactory get(ClientHttpRequestFactorySettings settings) {
        Assert.notNull((Object)settings, "Settings must not be null");
        if (APACHE_HTTP_CLIENT_PRESENT) {
            return HttpComponents.get(settings);
        }
        if (OKHTTP_CLIENT_PRESENT) {
            return OkHttp.get(settings);
        }
        return Simple.get(settings);
    }

    public static <T extends ClientHttpRequestFactory> T get(Class<T> requestFactoryType, ClientHttpRequestFactorySettings settings) {
        Assert.notNull((Object)settings, "Settings must not be null");
        if (requestFactoryType == ClientHttpRequestFactory.class) {
            return (T)ClientHttpRequestFactories.get(settings);
        }
        if (requestFactoryType == HttpComponentsClientHttpRequestFactory.class) {
            return (T)HttpComponents.get(settings);
        }
        if (requestFactoryType == OkHttp3ClientHttpRequestFactory.class) {
            return (T)OkHttp.get(settings);
        }
        if (requestFactoryType == SimpleClientHttpRequestFactory.class) {
            return (T)Simple.get(settings);
        }
        return (T)ClientHttpRequestFactories.get(() -> ClientHttpRequestFactories.createRequestFactory(requestFactoryType), settings);
    }

    public static <T extends ClientHttpRequestFactory> T get(Supplier<T> requestFactorySupplier, ClientHttpRequestFactorySettings settings) {
        return Reflective.get(requestFactorySupplier, settings);
    }

    private static <T extends ClientHttpRequestFactory> T createRequestFactory(Class<T> requestFactory) {
        try {
            Constructor<T> constructor = requestFactory.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (T)((ClientHttpRequestFactory)constructor.newInstance(new Object[0]));
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    static class HttpComponents {
        HttpComponents() {
        }

        static HttpComponentsClientHttpRequestFactory get(ClientHttpRequestFactorySettings settings) {
            HttpComponentsClientHttpRequestFactory requestFactory = HttpComponents.createRequestFactory(settings.readTimeout(), settings.sslBundle());
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(settings::connectTimeout).asInt(Duration::toMillis).to(arg_0 -> ((HttpComponentsClientHttpRequestFactory)requestFactory).setConnectTimeout(arg_0));
            map.from(settings::bufferRequestBody).to(arg_0 -> ((HttpComponentsClientHttpRequestFactory)requestFactory).setBufferRequestBody(arg_0));
            return requestFactory;
        }

        private static HttpComponentsClientHttpRequestFactory createRequestFactory(Duration readTimeout, SslBundle sslBundle) {
            return new HttpComponentsClientHttpRequestFactory(HttpComponents.createHttpClient(readTimeout, sslBundle));
        }

        private static HttpClient createHttpClient(Duration readTimeout, SslBundle sslBundle) {
            PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
            if (readTimeout != null) {
                SocketConfig socketConfig = SocketConfig.custom().setSoTimeout((int)readTimeout.toMillis(), TimeUnit.MILLISECONDS).build();
                connectionManagerBuilder.setDefaultSocketConfig(socketConfig);
            }
            if (sslBundle != null) {
                SslOptions options = sslBundle.getOptions();
                SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslBundle.createSslContext(), options.getEnabledProtocols(), options.getCiphers(), (HostnameVerifier)new DefaultHostnameVerifier());
                connectionManagerBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory);
            }
            PoolingHttpClientConnectionManager connectionManager = connectionManagerBuilder.build();
            return HttpClientBuilder.create().useSystemProperties().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        }
    }

    static class OkHttp {
        OkHttp() {
        }

        static OkHttp3ClientHttpRequestFactory get(ClientHttpRequestFactorySettings settings) {
            Assert.state(settings.bufferRequestBody() == null, () -> "OkHttp3ClientHttpRequestFactory does not support request body buffering");
            OkHttp3ClientHttpRequestFactory requestFactory = OkHttp.createRequestFactory(settings.sslBundle());
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(settings::connectTimeout).asInt(Duration::toMillis).to(arg_0 -> ((OkHttp3ClientHttpRequestFactory)requestFactory).setConnectTimeout(arg_0));
            map.from(settings::readTimeout).asInt(Duration::toMillis).to(arg_0 -> ((OkHttp3ClientHttpRequestFactory)requestFactory).setReadTimeout(arg_0));
            return requestFactory;
        }

        private static OkHttp3ClientHttpRequestFactory createRequestFactory(SslBundle sslBundle) {
            if (sslBundle != null) {
                Assert.state(!sslBundle.getOptions().isSpecified(), "SSL Options cannot be specified with OkHttp");
                SSLSocketFactory socketFactory = sslBundle.createSslContext().getSocketFactory();
                TrustManager[] trustManagers = sslBundle.getManagers().getTrustManagers();
                Assert.state(trustManagers.length == 1, "Trust material must be provided in the SSL bundle for OkHttp3ClientHttpRequestFactory");
                OkHttpClient client = new OkHttpClient.Builder().sslSocketFactory(socketFactory, (X509TrustManager)trustManagers[0]).build();
                return new OkHttp3ClientHttpRequestFactory(client);
            }
            return new OkHttp3ClientHttpRequestFactory();
        }
    }

    static class Simple {
        Simple() {
        }

        static SimpleClientHttpRequestFactory get(ClientHttpRequestFactorySettings settings) {
            SslBundle sslBundle = settings.sslBundle();
            SimpleClientHttpsRequestFactory requestFactory = sslBundle != null ? new SimpleClientHttpsRequestFactory(sslBundle) : new SimpleClientHttpRequestFactory();
            Assert.state(sslBundle == null || !sslBundle.getOptions().isSpecified(), "SSL Options cannot be specified with Java connections");
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(settings::readTimeout).asInt(Duration::toMillis).to(arg_0 -> ((SimpleClientHttpRequestFactory)requestFactory).setReadTimeout(arg_0));
            map.from(settings::connectTimeout).asInt(Duration::toMillis).to(arg_0 -> ((SimpleClientHttpRequestFactory)requestFactory).setConnectTimeout(arg_0));
            map.from(settings::bufferRequestBody).to(arg_0 -> ((SimpleClientHttpRequestFactory)requestFactory).setBufferRequestBody(arg_0));
            return requestFactory;
        }

        private static class SimpleClientHttpsRequestFactory
        extends SimpleClientHttpRequestFactory {
            private SslBundle sslBundle;

            SimpleClientHttpsRequestFactory(SslBundle sslBundle) {
                this.sslBundle = sslBundle;
            }

            protected void prepareConnection(HttpURLConnection connection, String httpMethod) throws IOException {
                super.prepareConnection(connection, httpMethod);
                if (this.sslBundle != null && connection instanceof HttpsURLConnection) {
                    HttpsURLConnection secureConnection = (HttpsURLConnection)connection;
                    SSLSocketFactory socketFactory = this.sslBundle.createSslContext().getSocketFactory();
                    secureConnection.setSSLSocketFactory(socketFactory);
                }
            }
        }
    }

    static class Reflective {
        Reflective() {
        }

        static <T extends ClientHttpRequestFactory> T get(Supplier<T> requestFactorySupplier, ClientHttpRequestFactorySettings settings) {
            ClientHttpRequestFactory requestFactory = (ClientHttpRequestFactory)requestFactorySupplier.get();
            Reflective.configure(requestFactory, settings);
            return (T)requestFactory;
        }

        private static void configure(ClientHttpRequestFactory requestFactory, ClientHttpRequestFactorySettings settings) {
            ClientHttpRequestFactory unwrapped = Reflective.unwrapRequestFactoryIfNecessary(requestFactory);
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(settings::connectTimeout).to(connectTimeout -> Reflective.setConnectTimeout(unwrapped, connectTimeout));
            map.from(settings::readTimeout).to(readTimeout -> Reflective.setReadTimeout(unwrapped, readTimeout));
            map.from(settings::bufferRequestBody).to(bufferRequestBody -> Reflective.setBufferRequestBody(unwrapped, bufferRequestBody));
        }

        private static ClientHttpRequestFactory unwrapRequestFactoryIfNecessary(ClientHttpRequestFactory requestFactory) {
            if (!(requestFactory instanceof AbstractClientHttpRequestFactoryWrapper)) {
                return requestFactory;
            }
            Field field2 = ReflectionUtils.findField(AbstractClientHttpRequestFactoryWrapper.class, "requestFactory");
            ReflectionUtils.makeAccessible(field2);
            ClientHttpRequestFactory unwrappedRequestFactory = requestFactory;
            while (unwrappedRequestFactory instanceof AbstractClientHttpRequestFactoryWrapper) {
                unwrappedRequestFactory = (ClientHttpRequestFactory)ReflectionUtils.getField(field2, unwrappedRequestFactory);
            }
            return unwrappedRequestFactory;
        }

        private static void setConnectTimeout(ClientHttpRequestFactory factory, Duration connectTimeout) {
            Method method = Reflective.findMethod(factory, "setConnectTimeout", Integer.TYPE);
            int timeout = Math.toIntExact(connectTimeout.toMillis());
            Reflective.invoke(factory, method, timeout);
        }

        private static void setReadTimeout(ClientHttpRequestFactory factory, Duration readTimeout) {
            Method method = Reflective.findMethod(factory, "setReadTimeout", Integer.TYPE);
            int timeout = Math.toIntExact(readTimeout.toMillis());
            Reflective.invoke(factory, method, timeout);
        }

        private static void setBufferRequestBody(ClientHttpRequestFactory factory, boolean bufferRequestBody) {
            Method method = Reflective.findMethod(factory, "setBufferRequestBody", Boolean.TYPE);
            Reflective.invoke(factory, method, bufferRequestBody);
        }

        private static Method findMethod(ClientHttpRequestFactory requestFactory, String methodName, Class<?> ... parameters) {
            Method method = ReflectionUtils.findMethod(requestFactory.getClass(), methodName, parameters);
            Assert.state(method != null, () -> "Request factory %s does not have a suitable %s method".formatted(requestFactory.getClass().getName(), methodName));
            Assert.state(!method.isAnnotationPresent(Deprecated.class), () -> "Request factory %s has the %s method marked as deprecated".formatted(requestFactory.getClass().getName(), methodName));
            return method;
        }

        private static void invoke(ClientHttpRequestFactory requestFactory, Method method, Object ... parameters) {
            ReflectionUtils.invokeMethod(method, requestFactory, parameters);
        }
    }
}

