/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit.functions;

import java.util.function.Function;
import java.util.stream.IntStream;

public final class SquareRootFunction
implements Function<Integer, Integer> {
    static final int[] lookup = new int[1000];
    private static final SquareRootFunction INSTANCE;

    public static Function<Integer, Integer> create(int baseline) {
        return INSTANCE.andThen(t2 -> Math.max(baseline, t2));
    }

    @Override
    public Integer apply(Integer t2) {
        return t2 < 1000 ? lookup[t2] : (int)Math.sqrt(t2.intValue());
    }

    static {
        IntStream.range(0, 1000).forEach(i -> {
            SquareRootFunction.lookup[i] = Math.max(1, (int)Math.sqrt(i));
        });
        INSTANCE = new SquareRootFunction();
    }
}

