/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.impl.GrpcStatusCode;
import io.camunda.zeebe.client.impl.ZeebeClientFutureImpl;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public final class RetriableClientFutureImpl<R, T>
extends ZeebeClientFutureImpl<R, T> {
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private final Consumer<StreamObserver<T>> retryAction;

    public RetriableClientFutureImpl(Predicate<CredentialsProvider.StatusCode> retryPredicate, Consumer<StreamObserver<T>> retryAction) {
        this(brokerResponse -> null, retryPredicate, retryAction);
    }

    public RetriableClientFutureImpl(Function<T, R> responseMapper, Predicate<CredentialsProvider.StatusCode> retryPredicate, Consumer<StreamObserver<T>> retryAction) {
        super(responseMapper);
        Objects.requireNonNull(retryPredicate, "Expected to have non-null retry predicate.");
        Objects.requireNonNull(retryAction, "Expected to have non-null retry action.");
        this.retryPredicate = retryPredicate;
        this.retryAction = retryAction;
    }

    @Override
    public void onError(Throwable throwable) {
        Status status = Status.fromThrowable(throwable);
        GrpcStatusCode statusCode = new GrpcStatusCode(status.getCode());
        if (this.retryPredicate.test(statusCode)) {
            this.retryAction.accept(this);
        } else {
            super.onError(throwable);
        }
    }
}

