/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.BroadcastSignalCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.BroadcastSignalResponse;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.command.CommandWithVariables;
import io.camunda.zeebe.client.impl.response.BroadcastSignalResponseImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class BroadcastSignalCommandImpl
extends CommandWithVariables<BroadcastSignalCommandImpl>
implements BroadcastSignalCommandStep1,
BroadcastSignalCommandStep1.BroadcastSignalCommandStep2 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private final GatewayOuterClass.BroadcastSignalRequest.Builder builder;
    private Duration requestTimeout;

    public BroadcastSignalCommandImpl(GatewayGrpc.GatewayStub asyncStub, ZeebeClientConfiguration configuration, JsonMapper jsonMapper, Predicate<CredentialsProvider.StatusCode> retryPredicate) {
        super(jsonMapper);
        this.asyncStub = asyncStub;
        this.retryPredicate = retryPredicate;
        this.builder = GatewayOuterClass.BroadcastSignalRequest.newBuilder();
        this.requestTimeout = configuration.getDefaultRequestTimeout();
        this.tenantId(configuration.getDefaultTenantId());
    }

    @Override
    protected BroadcastSignalCommandImpl setVariablesInternal(String variables) {
        this.builder.setVariables(variables);
        return this;
    }

    @Override
    public BroadcastSignalCommandStep1.BroadcastSignalCommandStep2 signalName(String signalName) {
        this.builder.setSignalName(signalName);
        return this;
    }

    @Override
    public BroadcastSignalCommandStep1.BroadcastSignalCommandStep2 tenantId(String tenantId) {
        this.builder.setTenantId(tenantId);
        return this;
    }

    @Override
    public FinalCommandStep<BroadcastSignalResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<BroadcastSignalResponse> send() {
        GatewayOuterClass.BroadcastSignalRequest request = this.builder.build();
        RetriableClientFutureImpl<BroadcastSignalResponse, GatewayOuterClass.BroadcastSignalResponse> future = new RetriableClientFutureImpl<BroadcastSignalResponse, GatewayOuterClass.BroadcastSignalResponse>(BroadcastSignalResponseImpl::new, this.retryPredicate, streamObserver -> this.send(request, (StreamObserver<GatewayOuterClass.BroadcastSignalResponse>)streamObserver));
        this.send(request, future);
        return future;
    }

    private void send(GatewayOuterClass.BroadcastSignalRequest request, StreamObserver<GatewayOuterClass.BroadcastSignalResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).broadcastSignal(request, streamObserver);
    }
}

