/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.util;

import io.camunda.zeebe.client.impl.Loggers;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;

public final class VersionUtil {
    public static final Logger LOG = Loggers.LOGGER;
    private static final String VERSION_PROPERTIES_PATH = "/client-java.properties";
    private static final String VERSION_PROPERTY_NAME = "zeebe.version";
    private static final String VERSION_DEV = "development";
    private static String version;

    private VersionUtil() {
    }

    public static String getVersion() {
        if (version == null) {
            version = VersionUtil.readProperty(VERSION_PROPERTY_NAME);
            if (version == null) {
                LOG.warn("Version is not found in version file.");
                version = VersionUtil.class.getPackage().getImplementationVersion();
            }
            if (version == null) {
                version = VERSION_DEV;
            }
        }
        return version;
    }

    private static String readProperty(String property) {
        String string;
        block8: {
            InputStream versionFileStream = VersionUtil.class.getResourceAsStream(VERSION_PROPERTIES_PATH);
            try {
                Properties props = new Properties();
                props.load(versionFileStream);
                string = props.getProperty(property);
                if (versionFileStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (versionFileStream != null) {
                        try {
                            versionFileStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error(String.format("Can't read version file: %s", VERSION_PROPERTIES_PATH), e);
                    return null;
                }
            }
            versionFileStream.close();
        }
        return string;
    }
}

