/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.db.impl;

import io.camunda.zeebe.db.ContainsForeignKeys;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class DbCompositeKey<FirstKeyType extends DbKey, SecondKeyType extends DbKey>
implements DbKey,
ContainsForeignKeys {
    final FirstKeyType first;
    final SecondKeyType second;
    final Collection<DbForeignKey<DbKey>> containedForeignKeys;

    public DbCompositeKey(FirstKeyType first, SecondKeyType second) {
        this.first = first;
        this.second = second;
        this.containedForeignKeys = DbCompositeKey.collectContainedForeignKeys(first, second);
    }

    public FirstKeyType first() {
        return this.first;
    }

    public SecondKeyType second() {
        return this.second;
    }

    @Override
    public Collection<DbForeignKey<DbKey>> containedForeignKeys() {
        return this.containedForeignKeys;
    }

    @Override
    public void wrap(DirectBuffer directBuffer, int offset, int length) {
        this.first.wrap(directBuffer, offset, length);
        int firstKeyLength = this.first.getLength();
        this.second.wrap(directBuffer, offset + firstKeyLength, length - firstKeyLength);
    }

    @Override
    public int getLength() {
        return this.first.getLength() + this.second.getLength();
    }

    @Override
    public void write(MutableDirectBuffer mutableDirectBuffer, int offset) {
        this.first.write(mutableDirectBuffer, offset);
        int firstKeyPartLength = this.first.getLength();
        this.second.write(mutableDirectBuffer, offset + firstKeyPartLength);
    }

    private static Collection<DbForeignKey<DbKey>> collectContainedForeignKeys(DbKey first, DbKey second) {
        ArrayList<DbForeignKey<DbKey>> result = new ArrayList<DbForeignKey<DbKey>>();
        if (first instanceof ContainsForeignKeys) {
            ContainsForeignKeys firstForeignKeyProvider = (ContainsForeignKeys)((Object)first);
            result.addAll(firstForeignKeyProvider.containedForeignKeys());
        }
        if (second instanceof ContainsForeignKeys) {
            ContainsForeignKeys secondForeignKeyProvider = (ContainsForeignKeys)((Object)second);
            result.addAll(secondForeignKeyProvider.containedForeignKeys());
        }
        return Collections.unmodifiableList(result);
    }

    public String toString() {
        return "DbCompositeKey{first=" + String.valueOf(this.first) + ", second=" + String.valueOf(this.second) + "}";
    }
}

