/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.db.impl;

import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.impl.ZeebeDbConstants;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class DbLong
implements DbKey,
DbValue {
    private long longValue;

    public void wrapLong(long value) {
        this.longValue = value;
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.longValue = buffer.getLong(offset, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public void write(MutableDirectBuffer buffer, int offset) {
        buffer.putLong(offset, this.longValue, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
    }

    public long getValue() {
        return this.longValue;
    }

    public String toString() {
        return "DbLong{" + this.longValue + "}";
    }
}

