/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.db.impl;

import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.impl.ZeebeDbConstants;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class DbString
implements DbKey,
DbValue {
    private final DirectBuffer bytes = new UnsafeBuffer(0L, 0);

    public void wrapString(String string) {
        this.bytes.wrap(string.getBytes());
    }

    public void wrapBuffer(DirectBuffer buffer) {
        this.bytes.wrap(buffer);
    }

    @Override
    public void wrap(DirectBuffer directBuffer, int offset, int length) {
        int stringLen = directBuffer.getInt(offset, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        byte[] b = new byte[stringLen];
        directBuffer.getBytes(offset += 4, b);
        this.bytes.wrap(b);
    }

    @Override
    public int getLength() {
        return 4 + this.bytes.capacity();
    }

    @Override
    public void write(MutableDirectBuffer mutableDirectBuffer, int offset) {
        int length = this.bytes.capacity();
        mutableDirectBuffer.putInt(offset, length, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        mutableDirectBuffer.putBytes(offset += 4, this.bytes, 0, this.bytes.capacity());
    }

    public String toString() {
        return BufferUtil.bufferAsString(this.bytes);
    }

    public DirectBuffer getBuffer() {
        return this.bytes;
    }
}

