/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.db.impl.rocksdb.transaction;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.ColumnFamilyMetrics;
import io.camunda.zeebe.db.ConsistencyChecksSettings;
import io.camunda.zeebe.db.ContainsForeignKeys;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.KeyValuePairVisitor;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDbInconsistentException;
import io.camunda.zeebe.db.impl.rocksdb.transaction.ColumnFamilyContext;
import io.camunda.zeebe.db.impl.rocksdb.transaction.DbNullKey;
import io.camunda.zeebe.db.impl.rocksdb.transaction.ForeignKeyChecker;
import io.camunda.zeebe.db.impl.rocksdb.transaction.TransactionConsumer;
import io.camunda.zeebe.db.impl.rocksdb.transaction.ZeebeTransaction;
import io.camunda.zeebe.db.impl.rocksdb.transaction.ZeebeTransactionDb;
import io.camunda.zeebe.protocol.EnumValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.prometheus.client.Histogram;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksIterator;

class TransactionalColumnFamily<ColumnFamilyNames extends Enum<? extends EnumValue>, KeyType extends DbKey, ValueType extends DbValue>
implements ColumnFamily<KeyType, ValueType> {
    private final ZeebeTransactionDb<ColumnFamilyNames> transactionDb;
    private final ConsistencyChecksSettings consistencyChecksSettings;
    private final ColumnFamilyNames columnFamily;
    private final TransactionContext context;
    private final ValueType valueInstance;
    private final KeyType keyInstance;
    private final ColumnFamilyContext columnFamilyContext;
    private final ForeignKeyChecker foreignKeyChecker;
    private final ColumnFamilyMetrics metrics;

    TransactionalColumnFamily(ZeebeTransactionDb<ColumnFamilyNames> transactionDb, ConsistencyChecksSettings consistencyChecksSettings, ColumnFamilyNames columnFamily, TransactionContext context, KeyType keyInstance, ValueType valueInstance, ColumnFamilyMetrics metrics) {
        this.transactionDb = transactionDb;
        this.consistencyChecksSettings = consistencyChecksSettings;
        this.columnFamily = columnFamily;
        this.context = context;
        this.keyInstance = keyInstance;
        this.valueInstance = valueInstance;
        this.metrics = metrics;
        this.columnFamilyContext = new ColumnFamilyContext(((EnumValue)columnFamily).getValue());
        this.foreignKeyChecker = new ForeignKeyChecker(transactionDb, consistencyChecksSettings);
    }

    @Override
    public void insert(KeyType key, ValueType value) {
        try (Histogram.Timer timer = this.metrics.measurePutLatency();){
            this.ensureInOpenTransaction(transaction -> {
                this.columnFamilyContext.writeKey((DbKey)key);
                this.columnFamilyContext.writeValue((DbValue)value);
                this.assertKeyDoesNotExist(transaction);
                this.assertForeignKeysExist(transaction, key, value);
                transaction.put(this.transactionDb.getDefaultNativeHandle(), this.columnFamilyContext.getKeyBufferArray(), this.columnFamilyContext.getKeyLength(), this.columnFamilyContext.getValueBufferArray(), value.getLength());
            });
        }
    }

    @Override
    public void update(KeyType key, ValueType value) {
        try (Histogram.Timer timer = this.metrics.measurePutLatency();){
            this.ensureInOpenTransaction(transaction -> {
                this.columnFamilyContext.writeKey((DbKey)key);
                this.columnFamilyContext.writeValue((DbValue)value);
                this.assertKeyExists(transaction);
                this.assertForeignKeysExist(transaction, key, value);
                transaction.put(this.transactionDb.getDefaultNativeHandle(), this.columnFamilyContext.getKeyBufferArray(), this.columnFamilyContext.getKeyLength(), this.columnFamilyContext.getValueBufferArray(), value.getLength());
            });
        }
    }

    @Override
    public void upsert(KeyType key, ValueType value) {
        try (Histogram.Timer timer = this.metrics.measurePutLatency();){
            this.ensureInOpenTransaction(transaction -> {
                this.columnFamilyContext.writeKey((DbKey)key);
                this.columnFamilyContext.writeValue((DbValue)value);
                this.assertForeignKeysExist(transaction, key, value);
                transaction.put(this.transactionDb.getDefaultNativeHandle(), this.columnFamilyContext.getKeyBufferArray(), this.columnFamilyContext.getKeyLength(), this.columnFamilyContext.getValueBufferArray(), value.getLength());
            });
        }
    }

    @Override
    public ValueType get(KeyType key) {
        try (Histogram.Timer timer = this.metrics.measureGetLatency();){
            this.ensureInOpenTransaction(transaction -> {
                this.columnFamilyContext.writeKey((DbKey)key);
                byte[] value = transaction.get(this.transactionDb.getDefaultNativeHandle(), this.transactionDb.getReadOptionsNativeHandle(), this.columnFamilyContext.getKeyBufferArray(), this.columnFamilyContext.getKeyLength());
                this.columnFamilyContext.wrapValueView(value);
            });
            DirectBuffer valueBuffer = this.columnFamilyContext.getValueView();
            if (valueBuffer != null) {
                this.valueInstance.wrap(valueBuffer, 0, valueBuffer.capacity());
                ValueType ValueType2 = this.valueInstance;
                return ValueType2;
            }
            ValueType ValueType3 = null;
            return ValueType3;
        }
    }

    @Override
    public void forEach(Consumer<ValueType> consumer) {
        this.ensureInOpenTransaction(transaction -> this.forEachInPrefix(new DbNullKey(), (k, v) -> {
            consumer.accept(v);
            return true;
        }));
    }

    @Override
    public void forEach(BiConsumer<KeyType, ValueType> consumer) {
        this.ensureInOpenTransaction(transaction -> this.forEachInPrefix(new DbNullKey(), (k, v) -> {
            consumer.accept(k, v);
            return true;
        }));
    }

    @Override
    public void whileTrue(KeyType startAtKey, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.ensureInOpenTransaction(transaction -> this.forEachInPrefix((DbKey)startAtKey, new DbNullKey(), visitor));
    }

    @Override
    public void whileTrue(KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.ensureInOpenTransaction(transaction -> this.forEachInPrefix(new DbNullKey(), visitor));
    }

    @Override
    public void whileEqualPrefix(DbKey keyPrefix, BiConsumer<KeyType, ValueType> visitor) {
        this.ensureInOpenTransaction(transaction -> this.forEachInPrefix(keyPrefix, (k, v) -> {
            visitor.accept(k, v);
            return true;
        }));
    }

    @Override
    public void whileEqualPrefix(DbKey keyPrefix, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.ensureInOpenTransaction(transaction -> this.forEachInPrefix(keyPrefix, visitor));
    }

    @Override
    public void whileEqualPrefix(DbKey keyPrefix, KeyType startAtKey, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.ensureInOpenTransaction(transaction -> this.forEachInPrefix((DbKey)startAtKey, keyPrefix, visitor));
    }

    @Override
    public void deleteExisting(KeyType key) {
        try (Histogram.Timer timer = this.metrics.measureDeleteLatency();){
            this.ensureInOpenTransaction(transaction -> {
                this.columnFamilyContext.writeKey((DbKey)key);
                this.assertKeyExists(transaction);
                transaction.delete(this.transactionDb.getDefaultNativeHandle(), this.columnFamilyContext.getKeyBufferArray(), this.columnFamilyContext.getKeyLength());
            });
        }
    }

    @Override
    public void deleteIfExists(KeyType key) {
        try (Histogram.Timer timer = this.metrics.measureDeleteLatency();){
            this.ensureInOpenTransaction(transaction -> {
                this.columnFamilyContext.writeKey((DbKey)key);
                transaction.delete(this.transactionDb.getDefaultNativeHandle(), this.columnFamilyContext.getKeyBufferArray(), this.columnFamilyContext.getKeyLength());
            });
        }
    }

    @Override
    public boolean exists(KeyType key) {
        try (Histogram.Timer timer = this.metrics.measureGetLatency();){
            this.ensureInOpenTransaction(transaction -> {
                this.columnFamilyContext.writeKey((DbKey)key);
                byte[] value = transaction.get(this.transactionDb.getDefaultNativeHandle(), this.transactionDb.getReadOptionsNativeHandle(), this.columnFamilyContext.getKeyBufferArray(), this.columnFamilyContext.getKeyLength());
                this.columnFamilyContext.wrapValueView(value);
            });
            boolean bl = !this.columnFamilyContext.isValueViewEmpty();
            return bl;
        }
    }

    @Override
    public boolean isEmpty() {
        AtomicBoolean isEmpty = new AtomicBoolean(true);
        this.ensureInOpenTransaction(transaction -> this.forEachInPrefix(new DbNullKey(), (key, value) -> {
            isEmpty.set(false);
            return false;
        }));
        return isEmpty.get();
    }

    @Override
    public long count() {
        return this.countEachInPrefix(new DbNullKey());
    }

    @Override
    public long countEqualPrefix(DbKey prefix) {
        return this.countEachInPrefix(prefix);
    }

    private void assertForeignKeysExist(ZeebeTransaction transaction, Object ... keys) throws Exception {
        if (!this.consistencyChecksSettings.enableForeignKeyChecks()) {
            return;
        }
        for (Object key : keys) {
            if (!(key instanceof ContainsForeignKeys)) continue;
            ContainsForeignKeys containsForeignKey = (ContainsForeignKeys)key;
            this.foreignKeyChecker.assertExists(transaction, containsForeignKey);
        }
    }

    private void assertKeyDoesNotExist(ZeebeTransaction transaction) throws Exception {
        if (!this.consistencyChecksSettings.enablePreconditions()) {
            return;
        }
        byte[] value = transaction.get(this.transactionDb.getDefaultNativeHandle(), this.transactionDb.getReadOptionsNativeHandle(), this.columnFamilyContext.getKeyBufferArray(), this.columnFamilyContext.getKeyLength());
        if (value != null) {
            throw new ZeebeDbInconsistentException("Key " + String.valueOf(this.keyInstance) + " in ColumnFamily " + String.valueOf(this.columnFamily) + " already exists");
        }
    }

    private void assertKeyExists(ZeebeTransaction transaction) throws Exception {
        if (!this.consistencyChecksSettings.enablePreconditions()) {
            return;
        }
        byte[] value = transaction.get(this.transactionDb.getDefaultNativeHandle(), this.transactionDb.getReadOptionsNativeHandle(), this.columnFamilyContext.getKeyBufferArray(), this.columnFamilyContext.getKeyLength());
        if (value == null) {
            throw new ZeebeDbInconsistentException("Key " + String.valueOf(this.keyInstance) + " in ColumnFamily " + String.valueOf(this.columnFamily) + " does not exist");
        }
    }

    private void ensureInOpenTransaction(TransactionConsumer operation) {
        this.context.runInTransaction(() -> operation.run((ZeebeTransaction)this.context.getCurrentTransaction()));
    }

    RocksIterator newIterator(TransactionContext context, ReadOptions options) {
        ZeebeTransaction currentTransaction = (ZeebeTransaction)context.getCurrentTransaction();
        return currentTransaction.newIterator(options, this.transactionDb.getDefaultHandle());
    }

    private void forEachInPrefix(DbKey prefix, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.forEachInPrefix(prefix, prefix, visitor);
    }

    private void forEachInPrefix(DbKey startAt, DbKey prefix, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        try (Histogram.Timer timer = this.metrics.measureIterateLatency();){
            DbKey seekTarget = Objects.requireNonNullElse(startAt, prefix);
            Objects.requireNonNull(prefix);
            Objects.requireNonNull(visitor);
            this.columnFamilyContext.withPrefixKey(prefix, (prefixKey, prefixLength) -> {
                try (RocksIterator iterator = this.newIterator(this.context, this.transactionDb.getPrefixReadOptions());){
                    boolean shouldVisitNext = true;
                    iterator.seek(this.columnFamilyContext.keyWithColumnFamily(seekTarget));
                    while (iterator.isValid() && shouldVisitNext) {
                        byte[] keyBytes = iterator.key();
                        if (!BufferUtil.startsWith(prefixKey, 0, prefixLength, keyBytes, 0, keyBytes.length)) {
                            break;
                        }
                        shouldVisitNext = this.visit(this.keyInstance, this.valueInstance, visitor, iterator);
                        iterator.next();
                    }
                }
            });
        }
    }

    private long countEachInPrefix(DbKey prefix) {
        DbKey seekTarget = Objects.requireNonNull(prefix);
        AtomicLong count = new AtomicLong(0L);
        this.columnFamilyContext.withPrefixKey(prefix, (prefixKey, prefixLength) -> {
            try (RocksIterator iterator = this.newIterator(this.context, this.transactionDb.getPrefixReadOptions());){
                iterator.seek(this.columnFamilyContext.keyWithColumnFamily(seekTarget));
                while (iterator.isValid()) {
                    byte[] keyBytes = iterator.key();
                    if (!BufferUtil.startsWith(prefixKey, 0, prefixLength, keyBytes, 0, keyBytes.length)) {
                        break;
                    }
                    count.getAndIncrement();
                    iterator.next();
                }
            }
        });
        return count.get();
    }

    private boolean visit(KeyType keyInstance, ValueType valueInstance, KeyValuePairVisitor<KeyType, ValueType> iteratorConsumer, RocksIterator iterator) {
        byte[] keyBytes = iterator.key();
        this.columnFamilyContext.wrapKeyView(keyBytes);
        this.columnFamilyContext.wrapValueView(iterator.value());
        DirectBuffer keyViewBuffer = this.columnFamilyContext.getKeyView();
        keyInstance.wrap(keyViewBuffer, 0, keyViewBuffer.capacity());
        DirectBuffer valueViewBuffer = this.columnFamilyContext.getValueView();
        valueInstance.wrap(valueViewBuffer, 0, valueViewBuffer.capacity());
        return iteratorConsumer.visit(keyInstance, valueInstance);
    }
}

