/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.deployment.model.element.AbstractFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableBoundaryEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCompensation;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMultiInstanceBody;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.compensation.CompensationSubscription;
import io.camunda.zeebe.engine.state.immutable.CompensationSubscriptionState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.compensation.CompensationSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.intent.CompensationSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class BpmnCompensationSubscriptionBehaviour {
    private static final long NONE_COMPENSATION_HANDLER_INSTANCE_KEY = -1L;
    private static final Predicate<CompensationSubscription> TRIGGER_ALL_SUBSCRIPTIONS = subscription -> true;
    private final KeyGenerator keyGenerator;
    private final StateWriter stateWriter;
    private final CompensationSubscriptionState compensationSubscriptionState;
    private final ProcessState processState;
    private final TypedCommandWriter commandWriter;
    private final BpmnStateBehavior stateBehavior;

    public BpmnCompensationSubscriptionBehaviour(KeyGenerator keyGenerator, ProcessingState processingState, Writers writers, BpmnStateBehavior stateBehavior) {
        this.keyGenerator = keyGenerator;
        this.processState = processingState.getProcessState();
        this.compensationSubscriptionState = processingState.getCompensationSubscriptionState();
        this.stateWriter = writers.state();
        this.commandWriter = writers.command();
        this.stateBehavior = stateBehavior;
    }

    public void createCompensationSubscription(ExecutableActivity element, BpmnElementContext context) {
        if (this.hasCompensationBoundaryEvent(element) || this.isFlowScopeWithSubscriptions(context)) {
            long key = this.keyGenerator.nextKey();
            String elementId = BufferUtil.bufferAsString(element.getId());
            CompensationSubscriptionRecord compensation = new CompensationSubscriptionRecord().setTenantId(context.getTenantId()).setProcessInstanceKey(context.getProcessInstanceKey()).setProcessDefinitionKey(context.getProcessDefinitionKey()).setCompensableActivityId(elementId).setCompensableActivityInstanceKey(context.getElementInstanceKey()).setCompensableActivityScopeKey(context.getFlowScopeKey());
            this.getCompensationHandlerId(element).ifPresent(compensation::setCompensationHandlerId);
            this.stateWriter.appendFollowUpEvent(key, CompensationSubscriptionIntent.CREATED, compensation);
        }
    }

    private boolean hasCompensationBoundaryEvent(ExecutableActivity element) {
        return element.getBoundaryEvents().stream().anyMatch(boundaryEvent -> boundaryEvent.getEventType() == BpmnEventType.COMPENSATION);
    }

    private boolean isFlowScopeWithSubscriptions(BpmnElementContext context) {
        BpmnElementType bpmnElementType = context.getBpmnElementType();
        if (bpmnElementType != BpmnElementType.SUB_PROCESS && bpmnElementType != BpmnElementType.MULTI_INSTANCE_BODY) {
            return false;
        }
        List<CompensationSubscription> subscriptions = this.compensationSubscriptionState.findSubscriptionsByProcessInstanceKey(context.getTenantId(), context.getProcessInstanceKey());
        return BpmnCompensationSubscriptionBehaviour.hasCompensationSubscriptionInScope(subscriptions, context.getElementInstanceKey());
    }

    private static boolean hasCompensationSubscriptionInScope(Collection<CompensationSubscription> subscriptions, long scopeKey) {
        return subscriptions.stream().anyMatch(subscription -> subscription.getRecord().getCompensableActivityScopeKey() == scopeKey);
    }

    private Optional<String> getCompensationHandlerId(ExecutableActivity element) {
        return element.getBoundaryEvents().stream().map(ExecutableCatchEventElement::getCompensation).filter(Objects::nonNull).map(ExecutableCompensation::getCompensationHandler).map(AbstractFlowElement::getId).map(BufferUtil::bufferAsString).findFirst();
    }

    public boolean triggerCompensation(ExecutableFlowElement element, BpmnElementContext context) {
        return this.triggerCompensationInScope(element, context, TRIGGER_ALL_SUBSCRIPTIONS);
    }

    public boolean triggerCompensationForActivity(ExecutableFlowElement element, ExecutableActivity compensationActivity, BpmnElementContext context) {
        String compensationActivityId = BufferUtil.bufferAsString(compensationActivity.getId());
        return this.triggerCompensationInScope(element, context, subscription -> subscription.getRecord().getCompensableActivityId().equals(compensationActivityId));
    }

    private boolean triggerCompensationInScope(ExecutableFlowElement element, BpmnElementContext context, Predicate<CompensationSubscription> subscriptionFilter) {
        List<Long> compensationScopeKeys = this.getCompensationScopeKeys(element, context);
        List<CompensationSubscription> notTriggeredSubscriptions = this.compensationSubscriptionState.findSubscriptionsByProcessInstanceKey(context.getTenantId(), context.getProcessInstanceKey()).stream().filter(Predicate.not(BpmnCompensationSubscriptionBehaviour::isCompensationTriggered)).toList();
        List<CompensationSubscription> subscriptionsWithinScope = notTriggeredSubscriptions.stream().filter(subscription -> compensationScopeKeys.contains(subscription.getRecord().getCompensableActivityScopeKey())).filter(subscriptionFilter).toList();
        if (subscriptionsWithinScope.isEmpty()) {
            return false;
        }
        subscriptionsWithinScope.forEach(subscription -> this.triggerCompensationForSubscription(context, (Collection<CompensationSubscription>)notTriggeredSubscriptions, (CompensationSubscription)subscription));
        return true;
    }

    private List<Long> getCompensationScopeKeys(ExecutableFlowElement element, BpmnElementContext context) {
        long compensationEventScopeKey = context.getFlowScopeKey();
        if (BpmnCompensationSubscriptionBehaviour.isElementInsideEventSubprocess(element)) {
            BpmnElementContext flowScopeContext = this.stateBehavior.getFlowScopeContext(context);
            long eventSubprocessScopeKey = flowScopeContext.getFlowScopeKey();
            return List.of(Long.valueOf(compensationEventScopeKey), Long.valueOf(eventSubprocessScopeKey));
        }
        return List.of(Long.valueOf(compensationEventScopeKey));
    }

    private static boolean isElementInsideEventSubprocess(ExecutableFlowElement element) {
        return element.getFlowScope().getElementType() == BpmnElementType.EVENT_SUB_PROCESS;
    }

    private static boolean isCompensationTriggered(CompensationSubscription compensationSubscription) {
        return !compensationSubscription.getRecord().getThrowEventId().isEmpty();
    }

    private void triggerCompensationForSubscription(BpmnElementContext context, Collection<CompensationSubscription> subscriptions, CompensationSubscription subscription) {
        long compensationHandlerInstanceKey = -1L;
        if (BpmnCompensationSubscriptionBehaviour.hasCompensationHandler(subscription)) {
            compensationHandlerInstanceKey = this.activateCompensationHandler(context, subscription.getRecord().getCompensableActivityId());
        }
        this.appendCompensationSubscriptionTriggerEvent(context, subscription, compensationHandlerInstanceKey);
        this.triggerCompensationFromTopToBottom(context, subscriptions, subscription.getRecord().getCompensableActivityInstanceKey());
    }

    private static boolean hasCompensationHandler(CompensationSubscription subscription) {
        return !subscription.getRecord().getCompensationHandlerId().isEmpty();
    }

    private long activateCompensationHandler(BpmnElementContext context, String elementId) {
        ExecutableBoundaryEvent boundaryEvent = this.getCompensationBoundaryEvent(context, elementId);
        this.activateAndCompleteCompensationBoundaryEvent(context, boundaryEvent);
        ExecutableActivity compensationHandler = boundaryEvent.getCompensation().getCompensationHandler();
        ProcessInstanceRecord compensationHandlerRecord = new ProcessInstanceRecord();
        compensationHandlerRecord.wrap(context.getRecordValue());
        compensationHandlerRecord.setElementId(compensationHandler.getId()).setBpmnElementType(compensationHandler.getElementType()).setBpmnEventType(BpmnEventType.COMPENSATION);
        long compensationHandlerInstanceKey = this.keyGenerator.nextKey();
        this.commandWriter.appendFollowUpCommand(compensationHandlerInstanceKey, ProcessInstanceIntent.ACTIVATE_ELEMENT, compensationHandlerRecord);
        return compensationHandlerInstanceKey;
    }

    private ExecutableBoundaryEvent getCompensationBoundaryEvent(BpmnElementContext context, String elementId) {
        ExecutableActivity activityToCompensate = this.processState.getFlowElement(context.getProcessDefinitionKey(), context.getTenantId(), BufferUtil.wrapString(elementId), ExecutableActivity.class);
        ExecutableFlowElement executableFlowElement = activityToCompensate.getFlowScope();
        if (executableFlowElement instanceof ExecutableMultiInstanceBody) {
            ExecutableMultiInstanceBody multiInstanceBody = (ExecutableMultiInstanceBody)executableFlowElement;
            activityToCompensate = multiInstanceBody;
        }
        return activityToCompensate.getBoundaryEvents().stream().filter(b -> b.getEventType() == BpmnEventType.COMPENSATION).findFirst().orElseThrow(() -> new BpmnProcessingException(context, "No compensation boundary event found for activity '%s'".formatted(elementId)));
    }

    private void activateAndCompleteCompensationBoundaryEvent(BpmnElementContext context, ExecutableBoundaryEvent boundaryEvent) {
        long boundaryEventKey = this.keyGenerator.nextKey();
        ProcessInstanceRecord boundaryEventRecord = new ProcessInstanceRecord();
        boundaryEventRecord.wrap(context.getRecordValue());
        boundaryEventRecord.setElementId(boundaryEvent.getId()).setBpmnElementType(boundaryEvent.getElementType()).setBpmnEventType(boundaryEvent.getEventType());
        this.stateWriter.appendFollowUpEvent(boundaryEventKey, ProcessInstanceIntent.ELEMENT_ACTIVATING, boundaryEventRecord);
        this.stateWriter.appendFollowUpEvent(boundaryEventKey, ProcessInstanceIntent.ELEMENT_ACTIVATED, boundaryEventRecord);
        this.stateWriter.appendFollowUpEvent(boundaryEventKey, ProcessInstanceIntent.ELEMENT_COMPLETING, boundaryEventRecord);
        this.stateWriter.appendFollowUpEvent(boundaryEventKey, ProcessInstanceIntent.ELEMENT_COMPLETED, boundaryEventRecord);
    }

    private void appendCompensationSubscriptionTriggerEvent(BpmnElementContext context, CompensationSubscription subscription, long compensationHandlerInstanceKey) {
        long key = subscription.getKey();
        CompensationSubscriptionRecord compensationRecord = subscription.getRecord();
        compensationRecord.setThrowEventId(BufferUtil.bufferAsString(context.getElementId())).setThrowEventInstanceKey(context.getElementInstanceKey()).setCompensationHandlerInstanceKey(compensationHandlerInstanceKey);
        this.stateWriter.appendFollowUpEvent(key, CompensationSubscriptionIntent.TRIGGERED, compensationRecord);
    }

    private void triggerCompensationFromTopToBottom(BpmnElementContext context, Collection<CompensationSubscription> subscriptions, long scopeKey) {
        subscriptions.stream().filter(subscription -> scopeKey == subscription.getRecord().getCompensableActivityScopeKey()).forEach(subscription -> this.triggerCompensationForSubscription(context, subscriptions, (CompensationSubscription)subscription));
    }

    public void completeCompensationHandler(BpmnElementContext context) {
        if (BpmnEventType.COMPENSATION != context.getBpmnEventType()) {
            return;
        }
        this.compensationSubscriptionState.findSubscriptionsByProcessInstanceKey(context.getTenantId(), context.getProcessInstanceKey()).stream().filter(BpmnCompensationSubscriptionBehaviour::isCompensationTriggered).filter(subscription -> subscription.getRecord().getCompensationHandlerInstanceKey() == context.getElementInstanceKey()).findFirst().ifPresent(compensation -> this.completeSubscription(context, (CompensationSubscription)compensation));
    }

    private void completeSubscription(BpmnElementContext context, CompensationSubscription compensation) {
        this.stateWriter.appendFollowUpEvent(compensation.getKey(), CompensationSubscriptionIntent.COMPLETED, compensation.getRecord());
        this.completeFlowScopeSubscriptionFromBottomToTop(context, compensation.getRecord().getCompensableActivityScopeKey());
        long throwEventInstanceKey = compensation.getRecord().getThrowEventInstanceKey();
        if (!this.hasSubscriptionForThrowEvent(context, throwEventInstanceKey)) {
            this.completeCompensationThrowEvent(throwEventInstanceKey);
        }
    }

    private void completeFlowScopeSubscriptionFromBottomToTop(BpmnElementContext context, long scopeKey) {
        List<CompensationSubscription> subscriptions = this.compensationSubscriptionState.findSubscriptionsByProcessInstanceKey(context.getTenantId(), context.getProcessInstanceKey());
        if (BpmnCompensationSubscriptionBehaviour.hasCompensationSubscriptionInScope(subscriptions, scopeKey)) {
            return;
        }
        subscriptions.stream().filter(subscription -> scopeKey == subscription.getRecord().getCompensableActivityInstanceKey()).filter(Predicate.not(BpmnCompensationSubscriptionBehaviour::hasCompensationHandler)).findFirst().ifPresent(flowScopeSubscription -> {
            this.stateWriter.appendFollowUpEvent(flowScopeSubscription.getKey(), CompensationSubscriptionIntent.COMPLETED, flowScopeSubscription.getRecord());
            this.completeFlowScopeSubscriptionFromBottomToTop(context, flowScopeSubscription.getRecord().getCompensableActivityScopeKey());
        });
    }

    private boolean hasSubscriptionForThrowEvent(BpmnElementContext context, long throwEventInstanceKey) {
        return !this.compensationSubscriptionState.findSubscriptionsByThrowEventInstanceKey(context.getTenantId(), context.getProcessInstanceKey(), throwEventInstanceKey).isEmpty();
    }

    private void completeCompensationThrowEvent(long throwEventInstanceKey) {
        Optional.ofNullable(this.stateBehavior.getElementInstance(throwEventInstanceKey)).ifPresent(compensationThrowEvent -> {
            long elementInstanceKey = compensationThrowEvent.getKey();
            ProcessInstanceRecord elementRecord = compensationThrowEvent.getValue();
            this.commandWriter.appendFollowUpCommand(elementInstanceKey, ProcessInstanceIntent.COMPLETE_ELEMENT, elementRecord);
        });
    }

    public void deleteSubscriptionsOfProcessInstance(BpmnElementContext context) {
        this.compensationSubscriptionState.findSubscriptionsByProcessInstanceKey(context.getTenantId(), context.getProcessInstanceKey()).forEach(this::appendCompensationSubscriptionDeleteEvent);
    }

    public void deleteSubscriptionsOfSubprocess(BpmnElementContext context) {
        List<CompensationSubscription> subscriptions = this.compensationSubscriptionState.findSubscriptionsByProcessInstanceKey(context.getTenantId(), context.getProcessInstanceKey());
        this.deleteSubscriptionsTopToBottom(subscriptions, context.getElementInstanceKey());
    }

    private void deleteSubscriptionsTopToBottom(Collection<CompensationSubscription> subscriptions, long scopeKey) {
        subscriptions.stream().filter(subscription -> scopeKey == subscription.getRecord().getCompensableActivityScopeKey()).forEach(subscription -> {
            this.appendCompensationSubscriptionDeleteEvent((CompensationSubscription)subscription);
            this.deleteSubscriptionsTopToBottom(subscriptions, subscription.getRecord().getCompensableActivityInstanceKey());
        });
    }

    private void appendCompensationSubscriptionDeleteEvent(CompensationSubscription subscription) {
        this.stateWriter.appendFollowUpEvent(subscription.getKey(), CompensationSubscriptionIntent.DELETED, subscription.getRecord());
    }
}

