/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.task;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnCompensationSubscriptionBehaviour;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnDecisionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.bpmn.task.JobWorkerTaskSupportingProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableBusinessRuleTask;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.util.Either;

public final class BusinessRuleTaskProcessor
extends JobWorkerTaskSupportingProcessor<ExecutableBusinessRuleTask> {
    private final BpmnDecisionBehavior decisionBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final BpmnCompensationSubscriptionBehaviour compensationSubscriptionBehaviour;

    public BusinessRuleTaskProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        super(bpmnBehaviors, stateTransitionBehavior);
        this.decisionBehavior = bpmnBehaviors.bpmnDecisionBehavior();
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.compensationSubscriptionBehaviour = bpmnBehaviors.compensationSubscriptionBehaviour();
    }

    @Override
    public Class<ExecutableBusinessRuleTask> getType() {
        return ExecutableBusinessRuleTask.class;
    }

    @Override
    protected boolean isJobBehavior(ExecutableBusinessRuleTask element, BpmnElementContext context) {
        if (element.getDecisionId() != null) {
            return false;
        }
        if (element.getJobWorkerProperties() == null) {
            throw new BpmnProcessingException(context, "Expected to process business rule task, but could not determine processing behavior");
        }
        return true;
    }

    @Override
    public Either<Failure, ?> onActivateInternal(ExecutableBusinessRuleTask element, BpmnElementContext context) {
        return this.variableMappingBehavior.applyInputMappings(context, element);
    }

    @Override
    protected Either<Failure, ?> onFinalizeActivationInternal(ExecutableBusinessRuleTask element, BpmnElementContext context) {
        return this.decisionBehavior.evaluateDecision(element, context).thenDo(ok -> {
            BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(context, element.getEventType());
            this.stateTransitionBehavior.completeElement(activated);
        });
    }

    @Override
    public Either<Failure, ?> onCompleteInternal(ExecutableBusinessRuleTask element, BpmnElementContext context) {
        return this.variableMappingBehavior.applyOutputMappings(context, element);
    }

    @Override
    protected Either<Failure, ?> onFinalizeCompletionInternal(ExecutableBusinessRuleTask element, BpmnElementContext context) {
        this.compensationSubscriptionBehaviour.createCompensationSubscription(element, context);
        return this.stateTransitionBehavior.transitionToCompleted(element, context).thenDo(completed -> {
            this.compensationSubscriptionBehaviour.completeCompensationHandler((BpmnElementContext)completed);
            this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed);
        });
    }

    @Override
    public void onTerminateInternal(ExecutableBusinessRuleTask element, BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.stateBehavior.getFlowScopeInstance(context);
        this.incidentBehavior.resolveIncidents(context);
        this.eventSubscriptionBehavior.findEventTrigger(context).filter(eventTrigger -> flowScopeInstance.isActive()).filter(eventTrigger -> !flowScopeInstance.isInterrupted()).ifPresentOrElse(eventTrigger -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context, element.getEventType());
            this.eventSubscriptionBehavior.activateTriggeredEvent(context.getElementInstanceKey(), terminated.getFlowScopeKey(), (EventTrigger)eventTrigger, terminated);
        }, () -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context, element.getEventType());
            this.stateTransitionBehavior.onElementTerminated(element, terminated);
        });
    }
}

