/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.task;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnCompensationSubscriptionBehaviour;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableJobWorkerTask;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.util.Either;

public final class JobWorkerTaskProcessor
implements BpmnElementProcessor<ExecutableJobWorkerTask> {
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnJobBehavior jobBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final BpmnCompensationSubscriptionBehaviour compensationSubscriptionBehaviour;

    public JobWorkerTaskProcessor(BpmnBehaviors behaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.eventSubscriptionBehavior = behaviors.eventSubscriptionBehavior();
        this.incidentBehavior = behaviors.incidentBehavior();
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.variableMappingBehavior = behaviors.variableMappingBehavior();
        this.jobBehavior = behaviors.jobBehavior();
        this.stateBehavior = behaviors.stateBehavior();
        this.compensationSubscriptionBehaviour = behaviors.compensationSubscriptionBehaviour();
    }

    @Override
    public Class<ExecutableJobWorkerTask> getType() {
        return ExecutableJobWorkerTask.class;
    }

    @Override
    public Either<Failure, ?> onActivate(ExecutableJobWorkerTask element, BpmnElementContext context) {
        return this.variableMappingBehavior.applyInputMappings(context, element);
    }

    @Override
    public Either<Failure, ?> finalizeActivation(ExecutableJobWorkerTask element, BpmnElementContext context) {
        return this.jobBehavior.evaluateJobExpressions(element.getJobWorkerProperties(), context).flatMap(j -> this.eventSubscriptionBehavior.subscribeToEvents(element, context).map(ok -> j)).thenDo(jobProperties -> {
            this.jobBehavior.createNewJob(context, element, (BpmnJobBehavior.JobProperties)jobProperties);
            this.stateTransitionBehavior.transitionToActivated(context, element.getEventType());
        });
    }

    @Override
    public Either<Failure, ?> onComplete(ExecutableJobWorkerTask element, BpmnElementContext context) {
        return this.variableMappingBehavior.applyOutputMappings(context, element).thenDo(ok -> this.eventSubscriptionBehavior.unsubscribeFromEvents(context));
    }

    @Override
    public Either<Failure, ?> finalizeCompletion(ExecutableJobWorkerTask element, BpmnElementContext context) {
        this.compensationSubscriptionBehaviour.createCompensationSubscription(element, context);
        return this.stateTransitionBehavior.transitionToCompleted(element, context).thenDo(completed -> {
            this.compensationSubscriptionBehaviour.completeCompensationHandler((BpmnElementContext)completed);
            this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed);
        });
    }

    @Override
    public void onTerminate(ExecutableJobWorkerTask element, BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.stateBehavior.getFlowScopeInstance(context);
        this.jobBehavior.cancelJob(context);
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        this.incidentBehavior.resolveIncidents(context);
        this.eventSubscriptionBehavior.findEventTrigger(context).filter(eventTrigger -> flowScopeInstance.isActive()).filter(eventTrigger -> !flowScopeInstance.isInterrupted()).ifPresentOrElse(eventTrigger -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context, element.getEventType());
            this.eventSubscriptionBehavior.activateTriggeredEvent(context.getElementInstanceKey(), terminated.getFlowScopeKey(), (EventTrigger)eventTrigger, terminated);
        }, () -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context, element.getEventType());
            this.stateTransitionBehavior.onElementTerminated(element, terminated);
        });
    }
}

