/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMessage;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSignal;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.MessageStartEventSubscriptionState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.SignalSubscriptionState;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalSubscriptionRecord;
import io.camunda.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.SignalSubscriptionIntent;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.function.Predicate;
import org.agrona.DirectBuffer;

public class StartEventSubscriptionManager {
    private final MessageStartEventSubscriptionRecord messageSubscriptionRecord = new MessageStartEventSubscriptionRecord();
    private final SignalSubscriptionRecord signalSubscriptionRecord = new SignalSubscriptionRecord();
    private final ProcessState processState;
    private final MessageStartEventSubscriptionState messageStartEventSubscriptionState;
    private final SignalSubscriptionState signalSubscriptionState;
    private final KeyGenerator keyGenerator;
    private final StateWriter stateWriter;

    public StartEventSubscriptionManager(ProcessingState processingState, KeyGenerator keyGenerator, StateWriter stateWriter) {
        this.processState = processingState.getProcessState();
        this.messageStartEventSubscriptionState = processingState.getMessageStartEventSubscriptionState();
        this.signalSubscriptionState = processingState.getSignalSubscriptionState();
        this.keyGenerator = keyGenerator;
        this.stateWriter = stateWriter;
    }

    public void tryReOpenStartEventSubscription(DeploymentRecord deploymentRecord) {
        for (ProcessMetadata processRecord : deploymentRecord.processesMetadata()) {
            if (processRecord.isDuplicate() || !this.isLatestProcess(processRecord)) continue;
            this.closeExistingStartEventSubscriptions(processRecord);
            this.openStartEventSubscriptions(processRecord);
        }
    }

    private boolean isLatestProcess(ProcessMetadata processRecord) {
        return this.processState.getLatestProcessVersionByProcessId(processRecord.getBpmnProcessIdBuffer(), processRecord.getTenantId()).getVersion() == processRecord.getVersion();
    }

    private void closeExistingStartEventSubscriptions(ProcessMetadata processRecord) {
        this.closeMessageExistingStartEventSubscriptions(processRecord);
        this.closeSignalExistingStartEventSubscriptions(processRecord);
    }

    public void closeStartEventSubscriptions(DeployedProcess deployedProcess) {
        if (deployedProcess.getProcess().hasMessageStartEvent()) {
            this.closeMessageStartEventSubscriptions(deployedProcess);
        }
        if (deployedProcess.getProcess().hasSignalStartEvent()) {
            this.closeSignalStartEventSubscriptions(deployedProcess);
        }
    }

    private void closeMessageExistingStartEventSubscriptions(ProcessMetadata processRecord) {
        DeployedProcess lastMsgProcess = this.findLastStartProcess(processRecord, ExecutableCatchEventElement::isMessage);
        if (lastMsgProcess == null) {
            return;
        }
        this.closeMessageStartEventSubscriptions(lastMsgProcess);
    }

    private void closeMessageStartEventSubscriptions(DeployedProcess deployedProcess) {
        this.messageStartEventSubscriptionState.visitSubscriptionsByProcessDefinition(deployedProcess.getKey(), subscription -> this.stateWriter.appendFollowUpEvent(subscription.getKey(), MessageStartEventSubscriptionIntent.DELETED, subscription.getRecord()));
    }

    private void closeSignalExistingStartEventSubscriptions(ProcessMetadata processRecord) {
        DeployedProcess lastSignalProcess = this.findLastStartProcess(processRecord, ExecutableCatchEventElement::isSignal);
        if (lastSignalProcess == null) {
            return;
        }
        this.closeSignalStartEventSubscriptions(lastSignalProcess);
    }

    private void closeSignalStartEventSubscriptions(DeployedProcess deployedProcess) {
        this.signalSubscriptionState.visitStartEventSubscriptionsByProcessDefinitionKey(deployedProcess.getKey(), subscription -> this.stateWriter.appendFollowUpEvent(subscription.getKey(), SignalSubscriptionIntent.DELETED, subscription.getRecord()));
    }

    private DeployedProcess findLastStartProcess(ProcessMetadata processRecord, Predicate<ExecutableCatchEventElement> hasStartEventMatching) {
        for (int version = processRecord.getVersion() - 1; version > 0; --version) {
            DeployedProcess lastStartProcess = this.processState.getProcessByProcessIdAndVersion(processRecord.getBpmnProcessIdBuffer(), version, processRecord.getTenantId());
            if (lastStartProcess == null || !lastStartProcess.getProcess().getStartEvents().stream().anyMatch(hasStartEventMatching)) continue;
            return lastStartProcess;
        }
        return null;
    }

    private void openStartEventSubscriptions(ProcessMetadata processRecord) {
        long processDefinitionKey = processRecord.getKey();
        DeployedProcess processDefinition = this.processState.getProcessByKeyAndTenant(processDefinitionKey, processRecord.getTenantId());
        ExecutableProcess process = processDefinition.getProcess();
        List<ExecutableStartEvent> startEvents = process.getStartEvents();
        for (ExecutableStartEvent startEvent : startEvents) {
            if (startEvent.isMessage()) {
                this.openMessageStartEventSubscription(processDefinition, startEvent);
                continue;
            }
            if (!startEvent.isSignal()) continue;
            this.openSignalStartEventSubscription(processDefinition, startEvent);
        }
    }

    public void openStartEventSubscriptions(DeployedProcess deployedProcess) {
        ExecutableProcess process = deployedProcess.getProcess();
        process.getStartEvents().forEach(startEvent -> {
            if (startEvent.isMessage()) {
                this.openMessageStartEventSubscription(deployedProcess, (ExecutableStartEvent)startEvent);
            } else if (startEvent.isSignal()) {
                this.openSignalStartEventSubscription(deployedProcess, (ExecutableStartEvent)startEvent);
            }
        });
    }

    private void openMessageStartEventSubscription(DeployedProcess processDefinition, ExecutableStartEvent startEvent) {
        ExecutableMessage message = startEvent.getMessage();
        message.getMessageName().map(BufferUtil::wrapString).ifPresent(messageNameBuffer -> {
            this.messageSubscriptionRecord.reset();
            this.messageSubscriptionRecord.setMessageName((DirectBuffer)messageNameBuffer).setProcessDefinitionKey(processDefinition.getKey()).setBpmnProcessId(processDefinition.getBpmnProcessId()).setStartEventId(startEvent.getId()).setTenantId(processDefinition.getTenantId());
            long subscriptionKey = this.keyGenerator.nextKey();
            this.stateWriter.appendFollowUpEvent(subscriptionKey, MessageStartEventSubscriptionIntent.CREATED, this.messageSubscriptionRecord);
        });
    }

    private void openSignalStartEventSubscription(DeployedProcess processDefinition, ExecutableStartEvent startEvent) {
        ExecutableSignal signal = startEvent.getSignal();
        signal.getSignalName().map(BufferUtil::wrapString).ifPresent(signalNameBuffer -> {
            this.signalSubscriptionRecord.reset();
            this.signalSubscriptionRecord.setSignalName((DirectBuffer)signalNameBuffer).setProcessDefinitionKey(processDefinition.getKey()).setBpmnProcessId(processDefinition.getBpmnProcessId()).setCatchEventId(startEvent.getId()).setTenantId(processDefinition.getTenantId());
            long subscriptionKey = this.keyGenerator.nextKey();
            this.stateWriter.appendFollowUpEvent(subscriptionKey, SignalSubscriptionIntent.CREATED, this.signalSubscriptionRecord);
        });
    }
}

