/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCompensation;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableError;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEscalation;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableLink;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMessage;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSignal;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.engine.processing.timer.CronTimer;
import io.camunda.zeebe.model.bpmn.instance.Association;
import io.camunda.zeebe.model.bpmn.instance.CatchEvent;
import io.camunda.zeebe.model.bpmn.instance.CompensateEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Error;
import io.camunda.zeebe.model.bpmn.instance.ErrorEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Escalation;
import io.camunda.zeebe.model.bpmn.instance.EscalationEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EventDefinition;
import io.camunda.zeebe.model.bpmn.instance.LinkEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Message;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Signal;
import io.camunda.zeebe.model.bpmn.instance.SignalEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.TimerEventDefinition;
import io.camunda.zeebe.model.bpmn.util.time.Interval;
import io.camunda.zeebe.model.bpmn.util.time.RepeatingInterval;
import io.camunda.zeebe.model.bpmn.util.time.TimeDateTimer;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Optional;

public final class CatchEventTransformer
implements ModelElementTransformer<CatchEvent> {
    @Override
    public Class<CatchEvent> getType() {
        return CatchEvent.class;
    }

    @Override
    public void transform(CatchEvent element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableCatchEventElement executableElement = process.getElementById(element.getId(), ExecutableCatchEventElement.class);
        if (!element.getEventDefinitions().isEmpty()) {
            this.transformEventDefinition(element, context, executableElement);
        }
    }

    private void transformEventDefinition(CatchEvent element, TransformContext context, ExecutableCatchEventElement executableElement) {
        EventDefinition eventDefinition = element.getEventDefinitions().iterator().next();
        if (eventDefinition instanceof MessageEventDefinition) {
            this.transformMessageEventDefinition(context, executableElement, (MessageEventDefinition)eventDefinition);
        } else if (eventDefinition instanceof TimerEventDefinition) {
            TimerEventDefinition timerDefinition = (TimerEventDefinition)eventDefinition;
            ExpressionLanguage expressionLanguage = context.getExpressionLanguage();
            this.transformTimerEventDefinition(expressionLanguage, executableElement, timerDefinition);
        } else if (eventDefinition instanceof ErrorEventDefinition) {
            this.transformErrorEventDefinition(context, executableElement, (ErrorEventDefinition)eventDefinition);
        } else if (eventDefinition instanceof LinkEventDefinition) {
            this.transformLinkEventDefinition(context, executableElement, (LinkEventDefinition)eventDefinition);
        } else if (eventDefinition instanceof EscalationEventDefinition) {
            this.transformEscalationEventDefinition(context, executableElement, (EscalationEventDefinition)eventDefinition);
        } else if (eventDefinition instanceof SignalEventDefinition) {
            this.transformSignalEventDefinition(context, executableElement, (SignalEventDefinition)eventDefinition);
        } else if (eventDefinition instanceof CompensateEventDefinition) {
            this.transformCompensationEventDefinition(context, element, executableElement, (CompensateEventDefinition)eventDefinition);
        }
    }

    private void transformMessageEventDefinition(TransformContext context, ExecutableCatchEventElement executableElement, MessageEventDefinition messageEventDefinition) {
        Message message = messageEventDefinition.getMessage();
        ExecutableMessage executableMessage = context.getMessage(message.getId());
        executableElement.setMessage(executableMessage);
        executableElement.setEventType(BpmnEventType.MESSAGE);
    }

    private void transformTimerEventDefinition(ExpressionLanguage expressionLanguage, ExecutableCatchEventElement executableElement, TimerEventDefinition timerEventDefinition) {
        executableElement.setEventType(BpmnEventType.TIMER);
        if (timerEventDefinition.getTimeDuration() != null) {
            String duration = timerEventDefinition.getTimeDuration().getTextContent();
            Expression expression = expressionLanguage.parseExpression(duration);
            executableElement.setTimerFactory((expressionProcessor, scopeKey) -> expressionProcessor.evaluateIntervalExpression(expression, (long)scopeKey).map(interval -> new RepeatingInterval(1, (Interval)interval)));
        } else if (timerEventDefinition.getTimeCycle() != null) {
            String cycle = timerEventDefinition.getTimeCycle().getTextContent();
            Expression expression = expressionLanguage.parseExpression(cycle);
            executableElement.setTimerFactory((expressionProcessor, scopeKey) -> {
                try {
                    return expressionProcessor.evaluateStringExpression(expression, (long)scopeKey).map(text -> {
                        if (text.startsWith("R")) {
                            return RepeatingInterval.parse(text);
                        }
                        return CronTimer.parse(text);
                    });
                }
                catch (DateTimeParseException e) {
                    return Either.left(new Failure(e.getMessage(), ErrorType.EXTRACT_VALUE_ERROR, (long)scopeKey));
                }
            });
        } else if (timerEventDefinition.getTimeDate() != null) {
            String timeDate = timerEventDefinition.getTimeDate().getTextContent();
            Expression expression = expressionLanguage.parseExpression(timeDate);
            executableElement.setTimerFactory((expressionProcessor, scopeKey) -> expressionProcessor.evaluateDateTimeExpression(expression, (Long)scopeKey).map(TimeDateTimer::new));
        }
    }

    private void transformErrorEventDefinition(TransformContext context, ExecutableCatchEventElement executableElement, ErrorEventDefinition errorEventDefinition) {
        ExecutableError executableError;
        Error error2 = errorEventDefinition.getError();
        if (error2 == null) {
            executableError = new ExecutableError("");
            executableError.setErrorCode(BufferUtil.wrapString(""));
        } else {
            executableError = context.getError(error2.getId());
        }
        executableElement.setError(executableError);
        executableElement.setEventType(BpmnEventType.ERROR);
    }

    public void transformLinkEventDefinition(TransformContext context, ExecutableCatchEventElement executableElement, LinkEventDefinition linkEventDefinition) {
        executableElement.setLink(true);
        executableElement.setEventType(BpmnEventType.LINK);
        ExecutableLink link = new ExecutableLink(linkEventDefinition.getId());
        link.setName(BufferUtil.wrapString(linkEventDefinition.getName()));
        link.setCatchEvent(executableElement);
        context.addLink(link);
    }

    private void transformEscalationEventDefinition(TransformContext context, ExecutableCatchEventElement executableElement, EscalationEventDefinition escalationEventDefinition) {
        ExecutableEscalation executableEscalation;
        Escalation escalation = escalationEventDefinition.getEscalation();
        if (escalation == null) {
            executableEscalation = new ExecutableEscalation("");
            executableEscalation.setEscalationCode(BufferUtil.wrapString(""));
        } else {
            executableEscalation = context.getEscalation(escalation.getId());
        }
        executableElement.setEscalation(executableEscalation);
        executableElement.setEventType(BpmnEventType.ESCALATION);
    }

    private void transformSignalEventDefinition(TransformContext context, ExecutableCatchEventElement executableElement, SignalEventDefinition signalEventDefinition) {
        Signal signal = signalEventDefinition.getSignal();
        ExecutableSignal executableSignal = context.getSignal(signal.getId());
        executableElement.setSignal(executableSignal);
        executableElement.setEventType(BpmnEventType.SIGNAL);
    }

    private void transformCompensationEventDefinition(TransformContext context, CatchEvent element, ExecutableCatchEventElement executableElement, CompensateEventDefinition eventDefinition) {
        Collection<Association> associations = element.getParentElement().getChildElementsByType(Association.class);
        Optional<String> compensationHandlerId = associations.stream().filter(association -> association.getSource().getId().equals(element.getId())).findFirst().map(association -> association.getTarget().getId());
        compensationHandlerId.ifPresent(id -> {
            ExecutableActivity compensationHandler = context.getCurrentProcess().getElementById((String)id, ExecutableActivity.class);
            ExecutableCompensation compensation = new ExecutableCompensation(eventDefinition.getId());
            compensation.setCompensationHandler(compensationHandler);
            executableElement.setCompensation(compensation);
        });
        executableElement.setEventType(BpmnEventType.COMPENSATION);
    }
}

