/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCompensation;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEndEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableError;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEscalation;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSignal;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.engine.processing.deployment.model.transformer.JobWorkerElementTransformer;
import io.camunda.zeebe.model.bpmn.instance.Activity;
import io.camunda.zeebe.model.bpmn.instance.CompensateEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EndEvent;
import io.camunda.zeebe.model.bpmn.instance.Error;
import io.camunda.zeebe.model.bpmn.instance.ErrorEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Escalation;
import io.camunda.zeebe.model.bpmn.instance.EscalationEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EventDefinition;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Signal;
import io.camunda.zeebe.model.bpmn.instance.SignalEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.TerminateEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskDefinition;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;

public final class EndEventTransformer
implements ModelElementTransformer<EndEvent> {
    private final JobWorkerElementTransformer<EndEvent> jobWorkerElementTransformer = new JobWorkerElementTransformer<EndEvent>(EndEvent.class);

    @Override
    public Class<EndEvent> getType() {
        return EndEvent.class;
    }

    @Override
    public void transform(EndEvent element, TransformContext context) {
        ExecutableProcess currentProcess = context.getCurrentProcess();
        ExecutableEndEvent endEvent = currentProcess.getElementById(element.getId(), ExecutableEndEvent.class);
        endEvent.setEventType(BpmnEventType.NONE);
        if (!element.getEventDefinitions().isEmpty()) {
            this.transformEventDefinition(element, context, endEvent);
        }
    }

    private void transformEventDefinition(EndEvent element, TransformContext context, ExecutableEndEvent executableElement) {
        EventDefinition eventDefinition = element.getEventDefinitions().iterator().next();
        if (eventDefinition instanceof MessageEventDefinition) {
            executableElement.setEventType(BpmnEventType.MESSAGE);
            if (this.hasTaskDefinition(element)) {
                this.jobWorkerElementTransformer.transform(element, context);
            }
        } else if (eventDefinition instanceof ErrorEventDefinition) {
            ErrorEventDefinition errorEventDefinition = (ErrorEventDefinition)eventDefinition;
            this.transformErrorEventDefinition(context, executableElement, errorEventDefinition);
        } else if (eventDefinition instanceof TerminateEventDefinition) {
            executableElement.setTerminateEndEvent(true);
            executableElement.setEventType(BpmnEventType.TERMINATE);
        } else if (eventDefinition instanceof EscalationEventDefinition) {
            EscalationEventDefinition escalationEventDefinition = (EscalationEventDefinition)eventDefinition;
            this.transformEscalationEventDefinition(context, executableElement, escalationEventDefinition);
        } else if (eventDefinition instanceof SignalEventDefinition) {
            SignalEventDefinition signalEventDefinition = (SignalEventDefinition)eventDefinition;
            this.transformSignalEventDefinition(context, executableElement, signalEventDefinition);
        } else if (eventDefinition instanceof CompensateEventDefinition) {
            CompensateEventDefinition compensateEventDefinition = (CompensateEventDefinition)eventDefinition;
            this.transformCompensationEventDefinition(context, executableElement, compensateEventDefinition);
        }
    }

    private void transformErrorEventDefinition(TransformContext context, ExecutableEndEvent executableElement, ErrorEventDefinition errorEventDefinition) {
        Error error2 = errorEventDefinition.getError();
        ExecutableError executableError = context.getError(error2.getId());
        executableElement.setError(executableError);
        executableElement.setEventType(BpmnEventType.ERROR);
    }

    private boolean hasTaskDefinition(EndEvent element) {
        return element.getSingleExtensionElement(ZeebeTaskDefinition.class) != null;
    }

    private void transformEscalationEventDefinition(TransformContext context, ExecutableEndEvent executableElement, EscalationEventDefinition escalationEventDefinition) {
        Escalation escalation = escalationEventDefinition.getEscalation();
        ExecutableEscalation executableEscalation = context.getEscalation(escalation.getId());
        executableElement.setEscalation(executableEscalation);
        executableElement.setEventType(BpmnEventType.ESCALATION);
    }

    private void transformSignalEventDefinition(TransformContext context, ExecutableEndEvent executableElement, SignalEventDefinition signalEventDefinition) {
        Signal signal = signalEventDefinition.getSignal();
        ExecutableSignal executableSignal = context.getSignal(signal.getId());
        executableElement.setSignal(executableSignal);
        executableElement.setEventType(BpmnEventType.SIGNAL);
    }

    private void transformCompensationEventDefinition(TransformContext context, ExecutableEndEvent executableElement, CompensateEventDefinition eventDefinition) {
        ExecutableCompensation compensation = new ExecutableCompensation(eventDefinition.getId());
        Activity activityRef = eventDefinition.getActivity();
        if (activityRef != null) {
            ExecutableActivity activity = context.getCurrentProcess().getElementById(activityRef.getId(), ExecutableActivity.class);
            compensation.setReferenceCompensationActivity(activity);
        }
        executableElement.setCompensation(compensation);
        executableElement.setEventType(BpmnEventType.COMPENSATION);
    }
}

