/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableError;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.model.bpmn.instance.Error;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Optional;

public class ErrorTransformer
implements ModelElementTransformer<Error> {
    @Override
    public Class<Error> getType() {
        return Error.class;
    }

    @Override
    public void transform(Error element, TransformContext context) {
        ExecutableError error2 = new ExecutableError(element.getId());
        ExpressionLanguage expressionLanguage = context.getExpressionLanguage();
        String errorCode = Optional.ofNullable(element.getErrorCode()).orElse("");
        Expression errorCodeExpression = expressionLanguage.parseExpression(errorCode);
        error2.setErrorCodeExpression(errorCodeExpression);
        if (errorCodeExpression.isStatic()) {
            error2.setErrorCode(BufferUtil.wrapString(errorCode));
        }
        context.addError(error2);
    }
}

