/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableBoundaryEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableLoopCharacteristics;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMultiInstanceBody;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.model.bpmn.instance.Activity;
import io.camunda.zeebe.model.bpmn.instance.LoopCharacteristics;
import io.camunda.zeebe.model.bpmn.instance.MultiInstanceLoopCharacteristics;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeLoopCharacteristics;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Collections;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public final class MultiInstanceActivityTransformer
implements ModelElementTransformer<Activity> {
    @Override
    public Class<Activity> getType() {
        return Activity.class;
    }

    @Override
    public void transform(Activity element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableActivity innerActivity = process.getElementById(element.getId(), ExecutableActivity.class);
        LoopCharacteristics loopCharacteristics = element.getLoopCharacteristics();
        if (loopCharacteristics instanceof MultiInstanceLoopCharacteristics) {
            MultiInstanceLoopCharacteristics loopCharacteristics2 = (MultiInstanceLoopCharacteristics)loopCharacteristics;
            ExecutableLoopCharacteristics miLoopCharacteristics = this.transformLoopCharacteristics(context, loopCharacteristics2);
            ExecutableMultiInstanceBody multiInstanceBody = new ExecutableMultiInstanceBody(element.getId(), miLoopCharacteristics, innerActivity);
            MultiInstanceActivityTransformer.transformMultiInstanceBody(process, innerActivity, multiInstanceBody);
        }
    }

    private ExecutableLoopCharacteristics transformLoopCharacteristics(TransformContext context, MultiInstanceLoopCharacteristics elementLoopCharacteristics) {
        boolean isSequential = elementLoopCharacteristics.isSequential();
        Optional<Expression> completionCondition = Optional.ofNullable(elementLoopCharacteristics.getCompletionCondition()).map(ModelElementInstance::getTextContent).filter(e -> !e.isEmpty()).map(context.getExpressionLanguage()::parseExpression);
        ZeebeLoopCharacteristics zeebeLoopCharacteristics = elementLoopCharacteristics.getSingleExtensionElement(ZeebeLoopCharacteristics.class);
        Expression inputCollection = context.getExpressionLanguage().parseExpression(zeebeLoopCharacteristics.getInputCollection());
        Optional<DirectBuffer> inputElement = Optional.ofNullable(zeebeLoopCharacteristics.getInputElement()).filter(e -> !e.isEmpty()).map(BufferUtil::wrapString);
        Optional<DirectBuffer> outputCollection = Optional.ofNullable(zeebeLoopCharacteristics.getOutputCollection()).filter(e -> !e.isEmpty()).map(BufferUtil::wrapString);
        Optional<Expression> outputElement = Optional.ofNullable(zeebeLoopCharacteristics.getOutputElement()).filter(e -> !e.isEmpty()).map(e -> context.getExpressionLanguage().parseExpression((String)e));
        return new ExecutableLoopCharacteristics(isSequential, completionCondition, inputCollection, inputElement, outputCollection, outputElement);
    }

    private static void transformMultiInstanceBody(ExecutableProcess process, ExecutableActivity innerActivity, ExecutableMultiInstanceBody multiInstanceBody) {
        multiInstanceBody.setElementType(BpmnElementType.MULTI_INSTANCE_BODY);
        multiInstanceBody.setFlowScope(innerActivity.getFlowScope());
        innerActivity.setFlowScope(multiInstanceBody);
        MultiInstanceActivityTransformer.attachEventsToMultiInstanceBody(innerActivity, multiInstanceBody);
        MultiInstanceActivityTransformer.connectSequenceFlowsToMultiInstanceBody(innerActivity, multiInstanceBody);
        MultiInstanceActivityTransformer.replaceCompensationHandlerWithMultiInstanceBody(process, innerActivity, multiInstanceBody);
        process.addFlowElement(multiInstanceBody);
    }

    private static void attachEventsToMultiInstanceBody(ExecutableActivity innerActivity, ExecutableMultiInstanceBody multiInstanceBody) {
        innerActivity.getBoundaryEvents().forEach(multiInstanceBody::attach);
        innerActivity.getEvents().removeAll(innerActivity.getBoundaryEvents());
        innerActivity.getEventSubprocesses().stream().map(ExecutableFlowElementContainer::getStartEvents).forEach(innerActivity.getEvents()::remove);
        innerActivity.getInterruptingElementIds().clear();
        innerActivity.getBoundaryEvents().clear();
    }

    private static void connectSequenceFlowsToMultiInstanceBody(ExecutableActivity innerActivity, ExecutableMultiInstanceBody multiInstanceBody) {
        innerActivity.getIncoming().forEach(flow -> flow.setTarget(multiInstanceBody));
        innerActivity.getOutgoing().forEach(flow -> flow.setSource(multiInstanceBody));
        multiInstanceBody.getOutgoing().addAll(Collections.unmodifiableList(innerActivity.getOutgoing()));
        innerActivity.getOutgoing().clear();
    }

    private static void replaceCompensationHandlerWithMultiInstanceBody(ExecutableProcess process, ExecutableActivity innerActivity, ExecutableMultiInstanceBody multiInstanceBody) {
        process.getFlowElements().stream().filter(ExecutableBoundaryEvent.class::isInstance).map(ExecutableBoundaryEvent.class::cast).filter(boundaryEvent -> boundaryEvent.getEventType() == BpmnEventType.COMPENSATION).map(ExecutableCatchEventElement::getCompensation).filter(compensation -> compensation.getCompensationHandler() == innerActivity).forEach(compensation -> compensation.setCompensationHandler(multiInstanceBody));
    }
}

