/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.engine.processing.deployment.model.transformer.zeebe.ExecutionListenerTransformer;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeExecutionListeners;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import java.util.Optional;

public final class ProcessTransformer
implements ModelElementTransformer<Process> {
    private final ExecutionListenerTransformer executionListenerTransformer = new ExecutionListenerTransformer();

    @Override
    public Class<Process> getType() {
        return Process.class;
    }

    @Override
    public void transform(Process element, TransformContext context) {
        String id = element.getId();
        ExecutableProcess process = new ExecutableProcess(id);
        process.setElementType(BpmnElementType.bpmnElementTypeFor(element.getElementType().getTypeName()));
        context.addProcess(process);
        context.setCurrentProcess(process);
        this.transformExecutionListeners(element, process, context.getExpressionLanguage());
    }

    private void transformExecutionListeners(Process element, ExecutableProcess flowNode, ExpressionLanguage expressionLanguage) {
        Optional.ofNullable(element.getSingleExtensionElement(ZeebeExecutionListeners.class)).ifPresent(listeners -> this.executionListenerTransformer.transform(flowNode, listeners.getExecutionListeners(), expressionLanguage));
    }
}

