/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.el.EvaluationResult;
import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.el.ResultType;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.Signal;
import io.camunda.zeebe.model.bpmn.instance.SignalEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

final class ProcessSignalStartEventSignalNameValidator
implements ModelElementValidator<StartEvent> {
    private final ExpressionLanguage expressionLanguage;

    ProcessSignalStartEventSignalNameValidator(ExpressionLanguage expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }

    @Override
    public Class<StartEvent> getElementType() {
        return StartEvent.class;
    }

    @Override
    public void validate(StartEvent element, ValidationResultCollector validationResultCollector) {
        if (element.getScope() instanceof Process) {
            element.getEventDefinitions().stream().filter(SignalEventDefinition.class::isInstance).map(SignalEventDefinition.class::cast).forEach(definition -> this.validateSignalName((SignalEventDefinition)definition, validationResultCollector));
        }
    }

    private void validateSignalName(SignalEventDefinition signalEventDefinition, ValidationResultCollector resultCollector) {
        Signal signal = signalEventDefinition.getSignal();
        if (signal == null) {
            return;
        }
        String nameExpression = signal.getName();
        if (nameExpression == null) {
            return;
        }
        Expression parseResult = this.expressionLanguage.parseExpression(nameExpression);
        EvaluationResult evaluationResult = this.expressionLanguage.evaluateExpression(parseResult, var -> null);
        if (evaluationResult.isFailure()) {
            resultCollector.addError(0, String.format("Expected constant expression but found '%s', which could not be evaluated without context: %s", nameExpression, evaluationResult.getFailureMessage()));
        } else if (evaluationResult.getType() != ResultType.STRING) {
            resultCollector.addError(0, String.format("Expected constant expression of type String for signal name '%s', but was %s", new Object[]{nameExpression, evaluationResult.getType()}));
        }
    }
}

