/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.collection.Tuple;
import java.util.List;

public class JobCommandPreconditionChecker {
    private static final String NO_JOB_FOUND_MESSAGE = "Expected to %s job with key '%d', but no such job was found";
    private static final String INVALID_JOB_STATE_MESSAGE = "Expected to %s job with key '%d', but it is in state '%s'";
    private final List<JobState.State> validStates;
    private final String intent;

    public JobCommandPreconditionChecker(String intent, List<JobState.State> validStates) {
        this.intent = intent;
        this.validStates = validStates;
    }

    protected Either<Tuple<RejectionType, String>, Void> check(JobState.State state, long jobKey) {
        if (this.validStates.contains((Object)state)) {
            return Either.right(null);
        }
        if (state == JobState.State.NOT_FOUND) {
            return Either.left(Tuple.of(RejectionType.NOT_FOUND, String.format(NO_JOB_FOUND_MESSAGE, this.intent, jobKey)));
        }
        return Either.left(Tuple.of(RejectionType.INVALID_STATE, String.format(INVALID_JOB_STATE_MESSAGE, new Object[]{this.intent, jobKey, state})));
    }
}

