/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;

public final class JobUpdateRetriesProcessor
implements CommandProcessor<JobRecord> {
    private static final String NO_JOB_FOUND_MESSAGE = "Expected to update retries for job with key '%d', but no such job was found";
    private static final String NEGATIVE_RETRIES_MESSAGE = "Expected to update retries for job with key '%d' with a positive amount of retries, but the amount given was '%d'";
    private final JobState jobState;

    public JobUpdateRetriesProcessor(ProcessingState state) {
        this.jobState = state.getJobState();
    }

    @Override
    public boolean onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        long key = command.getKey();
        int retries = ((JobRecord)command.getValue()).getRetries();
        if (retries > 0) {
            JobRecord job = this.jobState.getJob(key, command.getAuthorizations());
            if (job != null) {
                job.setRetries(retries);
                commandControl.accept(JobIntent.RETRIES_UPDATED, job);
            } else {
                commandControl.reject(RejectionType.NOT_FOUND, String.format(NO_JOB_FOUND_MESSAGE, key));
            }
        } else {
            commandControl.reject(RejectionType.INVALID_ARGUMENT, String.format(NEGATIVE_RETRIES_MESSAGE, key, retries));
        }
        return true;
    }
}

