/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.state.immutable.MessageState;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageBatchRecord;
import io.camunda.zeebe.protocol.record.intent.MessageBatchIntent;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.stream.api.scheduling.ProcessingScheduleService;
import io.camunda.zeebe.stream.api.scheduling.Task;
import io.camunda.zeebe.stream.api.scheduling.TaskResult;
import io.camunda.zeebe.stream.api.scheduling.TaskResultBuilder;
import java.time.Duration;
import org.agrona.collections.MutableInteger;

public final class MessageTimeToLiveChecker
implements Task {
    private final Duration executionInterval;
    private final int batchLimit;
    private final boolean enableMessageTtlCheckerAsync;
    private final ProcessingScheduleService scheduleService;
    private final MessageState messageState;
    private long currentTimestamp = -1L;
    private MessageState.Index lastIndex;

    public MessageTimeToLiveChecker(Duration executionInterval, int batchLimit, boolean enableMessageTtlCheckerAsync, ProcessingScheduleService scheduleService, MessageState messageState) {
        this.executionInterval = executionInterval;
        this.batchLimit = batchLimit;
        this.enableMessageTtlCheckerAsync = enableMessageTtlCheckerAsync;
        this.messageState = messageState;
        this.scheduleService = scheduleService;
        this.lastIndex = null;
    }

    @Override
    public TaskResult execute(TaskResultBuilder taskResultBuilder) {
        if (this.currentTimestamp == -1L) {
            this.currentTimestamp = ActorClock.currentTimeMillis();
        }
        MutableInteger counter = new MutableInteger(0);
        MessageBatchRecord messageBatchRecord = new MessageBatchRecord();
        boolean shouldContinueWhereLeftOff = this.messageState.visitMessagesWithDeadlineBeforeTimestamp(this.currentTimestamp, this.lastIndex, (deadline, expiredMessageKey) -> {
            MessageState.Index newIndex = new MessageState.Index(expiredMessageKey, deadline);
            boolean wasIndexAlreadyVisitedLastTime = newIndex.equals(this.lastIndex);
            this.lastIndex = newIndex;
            if (wasIndexAlreadyVisitedLastTime) {
                return true;
            }
            messageBatchRecord.addMessageKey(expiredMessageKey);
            return counter.incrementAndGet() < this.batchLimit;
        });
        if (!messageBatchRecord.isEmpty()) {
            taskResultBuilder.appendCommandRecord(MessageBatchIntent.EXPIRE, messageBatchRecord);
        }
        if (shouldContinueWhereLeftOff) {
            this.reschedule(Duration.ZERO);
        } else {
            this.lastIndex = null;
            this.currentTimestamp = -1L;
            this.reschedule(this.executionInterval);
        }
        return taskResultBuilder.build();
    }

    private void reschedule(Duration idleInterval) {
        if (this.enableMessageTtlCheckerAsync) {
            this.scheduleService.runDelayedAsync(idleInterval, this);
        } else {
            this.scheduleService.runDelayed(idleInterval, this);
        }
    }
}

