/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContextImpl;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEvent;
import io.camunda.zeebe.engine.processing.processinstance.ProcessInstanceMigrationPreconditionChecker;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.EventScopeInstanceState;
import io.camunda.zeebe.engine.state.immutable.IncidentState;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.UserTaskState;
import io.camunda.zeebe.engine.state.immutable.VariableState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.msgpack.spec.MsgPackHelper;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceMigrationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.impl.record.value.usertask.UserTaskRecord;
import io.camunda.zeebe.protocol.impl.record.value.variable.VariableRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceMigrationIntent;
import io.camunda.zeebe.protocol.record.intent.UserTaskIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceMigrationRecordValue;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public class ProcessInstanceMigrationMigrateProcessor
implements TypedRecordProcessor<ProcessInstanceMigrationRecord> {
    private static final Logger LOG = Loggers.ENGINE_PROCESSING_LOGGER;
    private static final UnsafeBuffer NIL_VALUE = new UnsafeBuffer(MsgPackHelper.NIL);
    private final VariableRecord variableRecord = new VariableRecord().setValue(NIL_VALUE);
    private final StateWriter stateWriter;
    private final TypedResponseWriter responseWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final ElementInstanceState elementInstanceState;
    private final ProcessState processState;
    private final JobState jobState;
    private final UserTaskState userTaskState;
    private final VariableState variableState;
    private final IncidentState incidentState;
    private final EventScopeInstanceState eventScopeInstanceState;
    private final ProcessMessageSubscriptionState processMessageSubscriptionState;
    private final CatchEventBehavior catchEventBehavior;

    public ProcessInstanceMigrationMigrateProcessor(Writers writers, ProcessingState processingState, BpmnBehaviors bpmnBehaviors) {
        this.stateWriter = writers.state();
        this.responseWriter = writers.response();
        this.rejectionWriter = writers.rejection();
        this.elementInstanceState = processingState.getElementInstanceState();
        this.processState = processingState.getProcessState();
        this.jobState = processingState.getJobState();
        this.userTaskState = processingState.getUserTaskState();
        this.variableState = processingState.getVariableState();
        this.incidentState = processingState.getIncidentState();
        this.eventScopeInstanceState = processingState.getEventScopeInstanceState();
        this.processMessageSubscriptionState = processingState.getProcessMessageSubscriptionState();
        this.catchEventBehavior = bpmnBehaviors.catchEventBehavior();
    }

    @Override
    public void processRecord(TypedRecord<ProcessInstanceMigrationRecord> command) {
        ProcessInstanceMigrationRecord value = (ProcessInstanceMigrationRecord)command.getValue();
        long processInstanceKey = value.getProcessInstanceKey();
        long targetProcessDefinitionKey = value.getTargetProcessDefinitionKey();
        List<ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> mappingInstructions = value.getMappingInstructions();
        ElementInstance processInstance = this.elementInstanceState.getInstance(processInstanceKey);
        ProcessInstanceMigrationPreconditionChecker.requireNonNullProcessInstance(processInstance, processInstanceKey);
        ProcessInstanceMigrationPreconditionChecker.requireAuthorizedTenant(command.getAuthorizations(), processInstance.getValue().getTenantId(), processInstanceKey);
        ProcessInstanceMigrationPreconditionChecker.requireNullParent(processInstance.getValue().getParentProcessInstanceKey(), processInstanceKey);
        ProcessInstanceMigrationPreconditionChecker.requireNonDuplicateSourceElementIds(mappingInstructions, processInstanceKey);
        DeployedProcess targetProcessDefinition = this.processState.getProcessByKeyAndTenant(targetProcessDefinitionKey, processInstance.getValue().getTenantId());
        DeployedProcess sourceProcessDefinition = this.processState.getProcessByKeyAndTenant(processInstance.getValue().getProcessDefinitionKey(), processInstance.getValue().getTenantId());
        ProcessInstanceMigrationPreconditionChecker.requireNonNullTargetProcessDefinition(targetProcessDefinition, targetProcessDefinitionKey);
        ProcessInstanceMigrationPreconditionChecker.requireReferredElementsExist(sourceProcessDefinition, targetProcessDefinition, mappingInstructions, processInstanceKey);
        ProcessInstanceMigrationPreconditionChecker.requireNoEventSubprocess(sourceProcessDefinition, targetProcessDefinition);
        Map<String, String> mappedElementIds = this.mapElementIds(mappingInstructions, processInstance, targetProcessDefinition);
        ArrayDeque<ElementInstance> elementInstances = new ArrayDeque<ElementInstance>(List.of(processInstance));
        while (!elementInstances.isEmpty()) {
            ElementInstance elementInstance = elementInstances.poll();
            this.tryMigrateElementInstance(elementInstance, sourceProcessDefinition, targetProcessDefinition, mappedElementIds);
            List<ElementInstance> children = this.elementInstanceState.getChildren(elementInstance.getKey());
            elementInstances.addAll(children);
        }
        this.stateWriter.appendFollowUpEvent(processInstanceKey, ProcessInstanceMigrationIntent.MIGRATED, value);
        this.responseWriter.writeEventOnCommand(processInstanceKey, ProcessInstanceMigrationIntent.MIGRATED, value, command);
    }

    @Override
    public TypedRecordProcessor.ProcessingError tryHandleError(TypedRecord<ProcessInstanceMigrationRecord> command, Throwable error2) {
        if (error2 instanceof ProcessInstanceMigrationPreconditionChecker.ProcessInstanceMigrationPreconditionFailedException) {
            ProcessInstanceMigrationPreconditionChecker.ProcessInstanceMigrationPreconditionFailedException e = (ProcessInstanceMigrationPreconditionChecker.ProcessInstanceMigrationPreconditionFailedException)error2;
            this.rejectionWriter.appendRejection(command, e.getRejectionType(), e.getMessage());
            this.responseWriter.writeRejectionOnCommand(command, e.getRejectionType(), e.getMessage());
            return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
        }
        if (error2 instanceof SafetyCheckFailedException) {
            SafetyCheckFailedException e = (SafetyCheckFailedException)error2;
            LOG.error(e.getMessage(), e);
            this.rejectionWriter.appendRejection(command, RejectionType.PROCESSING_ERROR, e.getMessage());
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.PROCESSING_ERROR, e.getMessage());
            return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
        }
        return TypedRecordProcessor.ProcessingError.UNEXPECTED_ERROR;
    }

    private Map<String, String> mapElementIds(List<ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> mappingInstructions, ElementInstance processInstance, DeployedProcess targetProcessDefinition) {
        Map<String, String> mappedElementIds = mappingInstructions.stream().collect(Collectors.toMap(ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue::getSourceElementId, ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue::getTargetElementId));
        mappedElementIds.put(processInstance.getValue().getBpmnProcessId(), BufferUtil.bufferAsString(targetProcessDefinition.getBpmnProcessId()));
        return mappedElementIds;
    }

    private void tryMigrateElementInstance(ElementInstance elementInstance, DeployedProcess sourceProcessDefinition, DeployedProcess targetProcessDefinition, Map<String, String> sourceElementIdToTargetElementId) {
        long jobIncidentKey;
        long processIncidentKey;
        ProcessInstanceRecord elementInstanceRecord = elementInstance.getValue();
        long processInstanceKey = elementInstanceRecord.getProcessInstanceKey();
        String elementId = elementInstanceRecord.getElementId();
        ProcessInstanceMigrationPreconditionChecker.requireSupportedElementType(elementInstanceRecord, processInstanceKey);
        String targetElementId = sourceElementIdToTargetElementId.get(elementId);
        ProcessInstanceMigrationPreconditionChecker.requireNonNullTargetElementId(targetElementId, processInstanceKey, elementId);
        ProcessInstanceMigrationPreconditionChecker.requireSameElementType(targetProcessDefinition, targetElementId, elementInstanceRecord, processInstanceKey);
        ProcessInstanceMigrationPreconditionChecker.requireSameUserTaskImplementation(targetProcessDefinition, targetElementId, elementInstance, processInstanceKey);
        ProcessInstanceMigrationPreconditionChecker.requireUnchangedFlowScope(this.elementInstanceState, elementInstanceRecord, targetProcessDefinition, targetElementId);
        ProcessInstanceMigrationPreconditionChecker.requireNoBoundaryEventInSource(sourceProcessDefinition, elementInstanceRecord, EnumSet.of(BpmnEventType.MESSAGE));
        ProcessInstanceMigrationPreconditionChecker.requireNoBoundaryEventInTarget(targetProcessDefinition, targetElementId, elementInstanceRecord, EnumSet.of(BpmnEventType.MESSAGE));
        ProcessInstanceMigrationPreconditionChecker.requireNoConcurrentCommand(this.eventScopeInstanceState, elementInstance, processInstanceKey);
        this.stateWriter.appendFollowUpEvent(elementInstance.getKey(), ProcessInstanceIntent.ELEMENT_MIGRATED, elementInstanceRecord.setProcessDefinitionKey(targetProcessDefinition.getKey()).setBpmnProcessId(targetProcessDefinition.getBpmnProcessId()).setVersion(targetProcessDefinition.getVersion()).setElementId(targetElementId));
        if (elementInstance.getJobKey() > 0L) {
            JobRecord job = this.jobState.getJob(elementInstance.getJobKey());
            if (job == null) {
                throw new SafetyCheckFailedException(String.format("Expected to migrate a job for process instance with key '%d', but could not find job with key '%d'. Please report this as a bug", processInstanceKey, elementInstance.getUserTaskKey()));
            }
            this.stateWriter.appendFollowUpEvent(elementInstance.getJobKey(), JobIntent.MIGRATED, job.setProcessDefinitionKey(targetProcessDefinition.getKey()).setProcessDefinitionVersion(targetProcessDefinition.getVersion()).setBpmnProcessId(targetProcessDefinition.getBpmnProcessId()).setElementId(targetElementId));
        }
        if ((processIncidentKey = this.incidentState.getProcessInstanceIncidentKey(elementInstance.getKey())) != -1L) {
            this.appendIncidentMigratedEvent(processIncidentKey, targetProcessDefinition, targetElementId, processInstanceKey);
        }
        if ((jobIncidentKey = this.incidentState.getJobIncidentKey(elementInstance.getJobKey())) != -1L) {
            this.appendIncidentMigratedEvent(jobIncidentKey, targetProcessDefinition, targetElementId, processInstanceKey);
        }
        if (elementInstance.getUserTaskKey() > 0L) {
            UserTaskRecord userTask = this.userTaskState.getUserTask(elementInstance.getUserTaskKey());
            if (userTask == null) {
                throw new SafetyCheckFailedException(String.format("Expected to migrate a user task for process instance with key '%d', but could not find user task with key '%d'. Please report this as a bug", processInstanceKey, elementInstance.getUserTaskKey()));
            }
            this.stateWriter.appendFollowUpEvent(elementInstance.getUserTaskKey(), UserTaskIntent.MIGRATED, userTask.setProcessDefinitionKey(targetProcessDefinition.getKey()).setProcessDefinitionVersion(targetProcessDefinition.getVersion()).setBpmnProcessId(targetProcessDefinition.getBpmnProcessId()).setElementId(targetElementId).setVariables(NIL_VALUE));
        }
        this.variableState.getVariablesLocal(elementInstance.getKey()).forEach(variable -> this.stateWriter.appendFollowUpEvent(variable.key(), VariableIntent.MIGRATED, this.variableRecord.setScopeKey(elementInstance.getKey()).setName(variable.name()).setProcessInstanceKey(elementInstance.getValue().getProcessInstanceKey()).setProcessDefinitionKey(targetProcessDefinition.getKey()).setBpmnProcessId(targetProcessDefinition.getBpmnProcessId()).setTenantId(elementInstance.getValue().getTenantId())));
        BpmnElementContextImpl context = new BpmnElementContextImpl();
        context.init(elementInstance.getKey(), elementInstanceRecord, elementInstance.getState());
        ExecutableActivity targetElement = targetProcessDefinition.getProcess().getElementById(targetElementId, ExecutableActivity.class);
        ArrayList subscribedMessageNames = new ArrayList();
        this.catchEventBehavior.subscribeToEvents(context, targetElement, catchEvent -> {
            ExecutableCatchEvent element = catchEvent.element();
            String targetCatchEventId = BufferUtil.bufferAsString(element.getId());
            ProcessInstanceMigrationPreconditionChecker.requireNoMappedCatchEventsInTarget(sourceElementIdToTargetElementId, targetCatchEventId, processInstanceKey, elementId, targetElementId);
            if (element.isMessage()) {
                this.requireNoSubscriptionForMessage(elementInstance, catchEvent.messageName(), elementInstanceRecord.getTenantId(), targetCatchEventId);
                subscribedMessageNames.add(catchEvent.messageName());
            }
            return true;
        }).ifLeft(failure -> {
            throw new ProcessInstanceMigrationPreconditionChecker.ProcessInstanceMigrationPreconditionFailedException("Expected to migrate process instance '%s' but active element with id '%s' is mapped to element with id '%s' that must be subscribed to a message catch event. %s".formatted(processInstanceKey, elementId, targetElementId, failure.getMessage()), RejectionType.INVALID_STATE);
        });
        this.catchEventBehavior.unsubscribeFromMessageEvents(elementInstance.getKey(), subscription -> {
            if (subscribedMessageNames.contains(subscription.getRecord().getMessageNameBuffer())) {
                return false;
            }
            String catchEventId = subscription.getRecord().getElementId();
            ProcessInstanceMigrationPreconditionChecker.requireNoMappedCatchEventsInSource(sourceElementIdToTargetElementId, catchEventId, processInstanceKey, elementId);
            return true;
        });
    }

    private void appendIncidentMigratedEvent(long incidentKey, DeployedProcess targetProcessDefinition, String targetElementId, long processInstanceKey) {
        IncidentRecord incidentRecord = this.incidentState.getIncidentRecord(incidentKey);
        if (incidentRecord == null) {
            throw new SafetyCheckFailedException(String.format("Expected to migrate a user task for process instance with key '%d', but could not find incident with key '%d'. Please report this as a bug", processInstanceKey, incidentKey));
        }
        this.stateWriter.appendFollowUpEvent(incidentKey, IncidentIntent.MIGRATED, incidentRecord.setProcessDefinitionKey(targetProcessDefinition.getKey()).setBpmnProcessId(targetProcessDefinition.getBpmnProcessId()).setElementId(BufferUtil.wrapString(targetElementId)));
    }

    private void requireNoSubscriptionForMessage(ElementInstance elementInstance, DirectBuffer messageName, String tenantId, String targetCatchEventId) {
        boolean existSubscriptionForMessageName = this.processMessageSubscriptionState.existSubscriptionForElementInstance(elementInstance.getKey(), messageName, tenantId);
        ProcessInstanceMigrationPreconditionChecker.requireNoSubscriptionForMessage(existSubscriptionForMessageName, elementInstance, messageName, targetCatchEventId);
    }

    public static final class SafetyCheckFailedException
    extends RuntimeException {
        public SafetyCheckFailedException(String message) {
            super(message);
        }
    }
}

