/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.resource;

import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.common.CommandDistributionBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.StartEventSubscriptionManager;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.streamprocessor.DistributedTypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.deployment.DeployedDrg;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.deployment.PersistedDecision;
import io.camunda.zeebe.engine.state.deployment.PersistedForm;
import io.camunda.zeebe.engine.state.immutable.BannedInstanceState;
import io.camunda.zeebe.engine.state.immutable.DecisionState;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.FormState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.TimerInstanceState;
import io.camunda.zeebe.engine.state.instance.TimerInstance;
import io.camunda.zeebe.model.bpmn.util.time.Timer;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRequirementsRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.FormRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.camunda.zeebe.protocol.impl.record.value.resource.ResourceDeletionRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.DecisionIntent;
import io.camunda.zeebe.protocol.record.intent.DecisionRequirementsIntent;
import io.camunda.zeebe.protocol.record.intent.FormIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.protocol.record.intent.ResourceDeletionIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.Optional;
import org.agrona.DirectBuffer;

public class ResourceDeletionDeleteProcessor
implements DistributedTypedRecordProcessor<ResourceDeletionRecord> {
    private final StateWriter stateWriter;
    private final TypedResponseWriter responseWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final KeyGenerator keyGenerator;
    private final DecisionState decisionState;
    private final CommandDistributionBehavior commandDistributionBehavior;
    private final ProcessState processState;
    private final ElementInstanceState elementInstanceState;
    private final TimerInstanceState timerInstanceState;
    private final BannedInstanceState bannedInstanceState;
    private final CatchEventBehavior catchEventBehavior;
    private final ExpressionProcessor expressionProcessor;
    private final StartEventSubscriptionManager startEventSubscriptionManager;
    private final FormState formState;

    public ResourceDeletionDeleteProcessor(Writers writers, KeyGenerator keyGenerator, ProcessingState processingState, CommandDistributionBehavior commandDistributionBehavior, BpmnBehaviors bpmnBehaviors) {
        this.stateWriter = writers.state();
        this.responseWriter = writers.response();
        this.rejectionWriter = writers.rejection();
        this.keyGenerator = keyGenerator;
        this.decisionState = processingState.getDecisionState();
        this.commandDistributionBehavior = commandDistributionBehavior;
        this.processState = processingState.getProcessState();
        this.elementInstanceState = processingState.getElementInstanceState();
        this.timerInstanceState = processingState.getTimerState();
        this.bannedInstanceState = processingState.getBannedInstanceState();
        this.catchEventBehavior = bpmnBehaviors.catchEventBehavior();
        this.expressionProcessor = bpmnBehaviors.expressionBehavior();
        this.startEventSubscriptionManager = new StartEventSubscriptionManager(processingState, keyGenerator, this.stateWriter);
        this.formState = processingState.getFormState();
    }

    @Override
    public void processNewCommand(TypedRecord<ResourceDeletionRecord> command) {
        ResourceDeletionRecord value = (ResourceDeletionRecord)command.getValue();
        long eventKey = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(eventKey, ResourceDeletionIntent.DELETING, value);
        this.tryDeleteResources(command);
        this.stateWriter.appendFollowUpEvent(eventKey, ResourceDeletionIntent.DELETED, value);
        this.commandDistributionBehavior.distributeCommand(eventKey, command);
        this.responseWriter.writeEventOnCommand(eventKey, ResourceDeletionIntent.DELETING, value, command);
    }

    @Override
    public void processDistributedCommand(TypedRecord<ResourceDeletionRecord> command) {
        ResourceDeletionRecord value = (ResourceDeletionRecord)command.getValue();
        this.stateWriter.appendFollowUpEvent(command.getKey(), ResourceDeletionIntent.DELETING, value);
        this.tryDeleteResources(command);
        this.stateWriter.appendFollowUpEvent(command.getKey(), ResourceDeletionIntent.DELETED, value);
        this.commandDistributionBehavior.acknowledgeCommand(command.getKey(), command);
    }

    @Override
    public TypedRecordProcessor.ProcessingError tryHandleError(TypedRecord<ResourceDeletionRecord> command, Throwable error2) {
        if (error2 instanceof NoSuchResourceException) {
            NoSuchResourceException exception = (NoSuchResourceException)error2;
            this.rejectionWriter.appendRejection(command, RejectionType.NOT_FOUND, exception.getMessage());
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.NOT_FOUND, exception.getMessage());
            return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
        }
        if (error2 instanceof ActiveProcessInstancesException) {
            ActiveProcessInstancesException exception = (ActiveProcessInstancesException)error2;
            this.rejectionWriter.appendRejection(command, RejectionType.INVALID_STATE, exception.getMessage());
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.INVALID_STATE, exception.getMessage());
            return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
        }
        return TypedRecordProcessor.ProcessingError.UNEXPECTED_ERROR;
    }

    private void tryDeleteResources(TypedRecord<ResourceDeletionRecord> command) {
        ResourceDeletionRecord value = (ResourceDeletionRecord)command.getValue();
        for (String tenantId : this.getAuthorizedTenants(command)) {
            Optional<DeployedProcess> processOptional = Optional.ofNullable(this.processState.getProcessByKeyAndTenant(value.getResourceKey(), tenantId));
            if (processOptional.isPresent()) {
                this.setTenantId(command, tenantId);
                this.deleteProcess(processOptional.get());
                return;
            }
            Optional<DeployedDrg> drgOptional = this.decisionState.findDecisionRequirementsByTenantAndKey(tenantId, value.getResourceKey());
            if (drgOptional.isPresent()) {
                this.setTenantId(command, tenantId);
                this.deleteDecisionRequirements(drgOptional.get());
                return;
            }
            Optional<PersistedForm> formOptional = this.formState.findFormByKey(value.getResourceKey(), tenantId);
            if (!formOptional.isPresent()) continue;
            this.setTenantId(command, tenantId);
            this.deleteForm(formOptional.get());
            return;
        }
        throw new NoSuchResourceException(value.getResourceKey());
    }

    private void deleteDecisionRequirements(DeployedDrg drg) {
        this.decisionState.findDecisionsByTenantAndDecisionRequirementsKey(drg.getTenantId(), drg.getDecisionRequirementsKey()).forEach(this::deleteDecision);
        DecisionRequirementsRecord drgRecord = new DecisionRequirementsRecord().setDecisionRequirementsId(BufferUtil.bufferAsString(drg.getDecisionRequirementsId())).setDecisionRequirementsName(BufferUtil.bufferAsString(drg.getDecisionRequirementsName())).setDecisionRequirementsVersion(drg.getDecisionRequirementsVersion()).setDecisionRequirementsKey(drg.getDecisionRequirementsKey()).setResourceName(BufferUtil.bufferAsString(drg.getResourceName())).setChecksum(drg.getChecksum()).setResource(drg.getResource()).setTenantId(drg.getTenantId());
        this.stateWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), DecisionRequirementsIntent.DELETED, drgRecord);
    }

    private void deleteDecision(PersistedDecision persistedDecision) {
        DecisionRecord decisionRecord = new DecisionRecord().setDecisionId(BufferUtil.bufferAsString(persistedDecision.getDecisionId())).setDecisionName(BufferUtil.bufferAsString(persistedDecision.getDecisionName())).setVersion(persistedDecision.getVersion()).setDecisionKey(persistedDecision.getDecisionKey()).setDecisionRequirementsId(BufferUtil.bufferAsString(persistedDecision.getDecisionRequirementsId())).setDecisionRequirementsKey(persistedDecision.getDecisionRequirementsKey()).setTenantId(persistedDecision.getTenantId());
        this.stateWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), DecisionIntent.DELETED, decisionRecord);
    }

    private void deleteProcess(DeployedProcess process) {
        DirectBuffer processIdBuffer = process.getBpmnProcessId();
        ProcessRecord processRecord = new ProcessRecord().setBpmnProcessId(processIdBuffer).setVersion(process.getVersion()).setKey(process.getKey()).setResourceName(process.getResourceName()).setTenantId(process.getTenantId());
        this.stateWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), ProcessIntent.DELETING, processRecord);
        String processId = processRecord.getBpmnProcessId();
        int latestVersion = this.processState.getLatestProcessVersion(processId, processRecord.getTenantId());
        if (latestVersion == process.getVersion()) {
            this.unsubscribeStartEvents(process);
            Optional<Integer> previousVersion = this.processState.findProcessVersionBefore(processId, latestVersion, processRecord.getTenantId());
            if (previousVersion.isPresent()) {
                DeployedProcess previousProcess = this.processState.getProcessByProcessIdAndVersion(processIdBuffer, previousVersion.get(), process.getTenantId());
                this.resubscribeStartEvents(previousProcess);
            }
        }
        List<Long> bannedInstances = this.bannedInstanceState.getBannedProcessInstanceKeys();
        boolean hasRunningInstances = this.elementInstanceState.hasActiveProcessInstances(process.getKey(), bannedInstances);
        if (hasRunningInstances) {
            throw new ActiveProcessInstancesException(process.getKey());
        }
        this.stateWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), ProcessIntent.DELETED, processRecord);
    }

    private void unsubscribeStartEvents(DeployedProcess deployedProcess) {
        ExecutableProcess process = deployedProcess.getProcess();
        if (process.hasTimerStartEvent()) {
            this.timerInstanceState.forEachTimerForElementInstance(-1L, timer -> {
                if (timer.getProcessDefinitionKey() == deployedProcess.getKey()) {
                    this.catchEventBehavior.unsubscribeFromTimerEvent((TimerInstance)timer);
                }
            });
        }
        this.startEventSubscriptionManager.closeStartEventSubscriptions(deployedProcess);
    }

    private void resubscribeStartEvents(DeployedProcess deployedProcess) {
        ExecutableProcess process = deployedProcess.getProcess();
        if (process.hasTimerStartEvent()) {
            process.getStartEvents().stream().filter(ExecutableCatchEventElement::isTimer).forEach(timerStartEvent -> {
                Either<Failure, Timer> failureOrTimer = timerStartEvent.getTimerFactory().apply(this.expressionProcessor, -1L);
                if (failureOrTimer.isLeft()) {
                    throw new ExpressionProcessor.EvaluationException(failureOrTimer.getLeft().getMessage());
                }
                this.catchEventBehavior.subscribeToTimerEvent(-1L, -1L, deployedProcess.getKey(), timerStartEvent.getId(), deployedProcess.getTenantId(), failureOrTimer.get());
            });
        }
        this.startEventSubscriptionManager.openStartEventSubscriptions(deployedProcess);
    }

    private void deleteForm(PersistedForm persistedForm) {
        FormRecord form = new FormRecord().setFormId(persistedForm.getFormId()).setFormKey(persistedForm.getFormKey()).setTenantId(persistedForm.getTenantId()).setResourceName(persistedForm.getResourceName()).setResource(persistedForm.getResource()).setChecksum(persistedForm.getChecksum()).setVersion(persistedForm.getVersion());
        this.stateWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), FormIntent.DELETED, form);
    }

    private List<String> getAuthorizedTenants(TypedRecord<ResourceDeletionRecord> command) {
        String tenantId = ((ResourceDeletionRecord)command.getValue()).getTenantId();
        if (tenantId.isEmpty()) {
            return command.getAuthorizations().getOrDefault("authorized_tenants", List.of());
        }
        return List.of(tenantId);
    }

    private void setTenantId(TypedRecord<ResourceDeletionRecord> command, String tenantId) {
        ((ResourceDeletionRecord)command.getValue()).setTenantId(tenantId);
    }

    private static final class NoSuchResourceException
    extends IllegalStateException {
        private static final String ERROR_MESSAGE_RESOURCE_NOT_FOUND = "Expected to delete resource but no resource found with key `%d`";

        private NoSuchResourceException(long resourceKey) {
            super(String.format(ERROR_MESSAGE_RESOURCE_NOT_FOUND, resourceKey));
        }
    }

    private static final class ActiveProcessInstancesException
    extends IllegalStateException {
        private static final String ERROR_MESSAGE_RUNNING_INSTANCES = "Expected to delete resource with key `%d` but there are still running instances";

        private ActiveProcessInstancesException(long processDefinitionKey) {
            super(String.format(ERROR_MESSAGE_RUNNING_INSTANCES, processDefinitionKey));
        }
    }
}

