/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.timer;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import io.camunda.zeebe.model.bpmn.util.time.Interval;
import io.camunda.zeebe.model.bpmn.util.time.Timer;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import java.util.Optional;

public class CronTimer
implements Timer {
    private final Cron cron;
    private int repetitions;

    public CronTimer(Cron cron) {
        this.cron = cron;
    }

    @Override
    public Interval getInterval() {
        return null;
    }

    @Override
    public int getRepetitions() {
        return this.repetitions;
    }

    @Override
    public long getDueDate(long fromEpochMilli) {
        this.repetitions = -1;
        Optional<Long> next = ExecutionTime.forCron(this.cron).nextExecution(ZonedDateTime.ofInstant(Instant.ofEpochMilli(fromEpochMilli), ZoneId.systemDefault())).map(ChronoZonedDateTime::toInstant).map(Instant::toEpochMilli);
        if (next.isEmpty()) {
            this.repetitions = 0;
        }
        return next.orElse(fromEpochMilli);
    }

    public static CronTimer parse(String text) {
        try {
            Cron cron = new CronParser(CronDefinitionBuilder.instanceDefinitionFor(CronType.SPRING53)).parse(text);
            return new CronTimer(cron);
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            throw new DateTimeParseException(ex.getMessage(), Objects.requireNonNullElse(text, ""), 0);
        }
    }
}

