/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state;

import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.state.compensation.DbCompensationSubscriptionState;
import io.camunda.zeebe.engine.state.deployment.DbDecisionState;
import io.camunda.zeebe.engine.state.deployment.DbDeploymentState;
import io.camunda.zeebe.engine.state.deployment.DbFormState;
import io.camunda.zeebe.engine.state.deployment.DbProcessState;
import io.camunda.zeebe.engine.state.distribution.DbDistributionState;
import io.camunda.zeebe.engine.state.immutable.PendingMessageSubscriptionState;
import io.camunda.zeebe.engine.state.immutable.PendingProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.instance.DbElementInstanceState;
import io.camunda.zeebe.engine.state.instance.DbEventScopeInstanceState;
import io.camunda.zeebe.engine.state.instance.DbIncidentState;
import io.camunda.zeebe.engine.state.instance.DbJobState;
import io.camunda.zeebe.engine.state.instance.DbTimerInstanceState;
import io.camunda.zeebe.engine.state.instance.DbUserTaskState;
import io.camunda.zeebe.engine.state.message.DbMessageStartEventSubscriptionState;
import io.camunda.zeebe.engine.state.message.DbMessageState;
import io.camunda.zeebe.engine.state.message.DbMessageSubscriptionState;
import io.camunda.zeebe.engine.state.message.DbProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.message.TransientPendingSubscriptionState;
import io.camunda.zeebe.engine.state.migration.DbMigrationState;
import io.camunda.zeebe.engine.state.mutable.MutableBannedInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableCompensationSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableDecisionState;
import io.camunda.zeebe.engine.state.mutable.MutableDeploymentState;
import io.camunda.zeebe.engine.state.mutable.MutableDistributionState;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableFormState;
import io.camunda.zeebe.engine.state.mutable.MutableIncidentState;
import io.camunda.zeebe.engine.state.mutable.MutableJobState;
import io.camunda.zeebe.engine.state.mutable.MutableMessageStartEventSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableMessageState;
import io.camunda.zeebe.engine.state.mutable.MutableMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableMigrationState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.state.mutable.MutableSignalSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableTimerInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableUserTaskState;
import io.camunda.zeebe.engine.state.mutable.MutableVariableState;
import io.camunda.zeebe.engine.state.processing.DbBannedInstanceState;
import io.camunda.zeebe.engine.state.signal.DbSignalSubscriptionState;
import io.camunda.zeebe.engine.state.variable.DbVariableState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.stream.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import java.util.Objects;
import java.util.function.BiConsumer;

public class ProcessingDbState
implements MutableProcessingState {
    private final ZeebeDb<ZbColumnFamilies> zeebeDb;
    private final KeyGenerator keyGenerator;
    private final MutableProcessState processState;
    private final MutableTimerInstanceState timerInstanceState;
    private final MutableElementInstanceState elementInstanceState;
    private final MutableEventScopeInstanceState eventScopeInstanceState;
    private final MutableVariableState variableState;
    private final MutableDeploymentState deploymentState;
    private final MutableJobState jobState;
    private final MutableMessageState messageState;
    private final DbMessageSubscriptionState messageSubscriptionState;
    private final MutableMessageStartEventSubscriptionState messageStartEventSubscriptionState;
    private final DbProcessMessageSubscriptionState processMessageSubscriptionState;
    private final MutableIncidentState incidentState;
    private final MutableBannedInstanceState bannedInstanceState;
    private final MutableMigrationState mutableMigrationState;
    private final MutableDecisionState decisionState;
    private final MutableFormState formState;
    private final MutableSignalSubscriptionState signalSubscriptionState;
    private final MutableDistributionState distributionState;
    private final MutableUserTaskState userTaskState;
    private final MutableCompensationSubscriptionState compensationSubscriptionState;
    private final int partitionId;

    public ProcessingDbState(int partitionId, ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, KeyGenerator keyGenerator, TransientPendingSubscriptionState transientMessageSubscriptionState, TransientPendingSubscriptionState transientProcessMessageSubscriptionState, EngineConfiguration config) {
        this.partitionId = partitionId;
        this.zeebeDb = zeebeDb;
        this.keyGenerator = Objects.requireNonNull(keyGenerator);
        this.variableState = new DbVariableState(zeebeDb, transactionContext);
        this.processState = new DbProcessState(zeebeDb, transactionContext, config);
        this.timerInstanceState = new DbTimerInstanceState(zeebeDb, transactionContext);
        this.elementInstanceState = new DbElementInstanceState(zeebeDb, transactionContext, this.variableState);
        this.eventScopeInstanceState = new DbEventScopeInstanceState(zeebeDb, transactionContext);
        this.deploymentState = new DbDeploymentState(zeebeDb, transactionContext);
        this.jobState = new DbJobState(zeebeDb, transactionContext);
        this.messageState = new DbMessageState(zeebeDb, transactionContext, partitionId);
        this.messageSubscriptionState = new DbMessageSubscriptionState(zeebeDb, transactionContext, transientMessageSubscriptionState);
        this.messageStartEventSubscriptionState = new DbMessageStartEventSubscriptionState(zeebeDb, transactionContext);
        this.processMessageSubscriptionState = new DbProcessMessageSubscriptionState(zeebeDb, transactionContext, transientProcessMessageSubscriptionState);
        this.incidentState = new DbIncidentState(zeebeDb, transactionContext, partitionId);
        this.bannedInstanceState = new DbBannedInstanceState(zeebeDb, transactionContext, partitionId);
        this.decisionState = new DbDecisionState(zeebeDb, transactionContext, config);
        this.formState = new DbFormState(zeebeDb, transactionContext, config);
        this.signalSubscriptionState = new DbSignalSubscriptionState(zeebeDb, transactionContext);
        this.distributionState = new DbDistributionState(zeebeDb, transactionContext);
        this.mutableMigrationState = new DbMigrationState(zeebeDb, transactionContext);
        this.userTaskState = new DbUserTaskState(zeebeDb, transactionContext);
        this.compensationSubscriptionState = new DbCompensationSubscriptionState(zeebeDb, transactionContext);
    }

    @Override
    public void onRecovered(ReadonlyStreamProcessorContext context) {
        this.messageSubscriptionState.onRecovered(context);
        this.processMessageSubscriptionState.onRecovered(context);
        this.bannedInstanceState.onRecovered(context);
        this.messageState.onRecovered(context);
    }

    @Override
    public MutableDeploymentState getDeploymentState() {
        return this.deploymentState;
    }

    @Override
    public MutableProcessState getProcessState() {
        return this.processState;
    }

    @Override
    public MutableJobState getJobState() {
        return this.jobState;
    }

    @Override
    public MutableMessageState getMessageState() {
        return this.messageState;
    }

    @Override
    public MutableMessageSubscriptionState getMessageSubscriptionState() {
        return this.messageSubscriptionState;
    }

    @Override
    public MutableMessageStartEventSubscriptionState getMessageStartEventSubscriptionState() {
        return this.messageStartEventSubscriptionState;
    }

    @Override
    public MutableProcessMessageSubscriptionState getProcessMessageSubscriptionState() {
        return this.processMessageSubscriptionState;
    }

    @Override
    public MutableIncidentState getIncidentState() {
        return this.incidentState;
    }

    @Override
    public MutableBannedInstanceState getBannedInstanceState() {
        return this.bannedInstanceState;
    }

    @Override
    public MutableVariableState getVariableState() {
        return this.variableState;
    }

    @Override
    public MutableTimerInstanceState getTimerState() {
        return this.timerInstanceState;
    }

    @Override
    public MutableElementInstanceState getElementInstanceState() {
        return this.elementInstanceState;
    }

    @Override
    public MutableEventScopeInstanceState getEventScopeInstanceState() {
        return this.eventScopeInstanceState;
    }

    @Override
    public MutableDecisionState getDecisionState() {
        return this.decisionState;
    }

    @Override
    public MutableFormState getFormState() {
        return this.formState;
    }

    @Override
    public MutableSignalSubscriptionState getSignalSubscriptionState() {
        return this.signalSubscriptionState;
    }

    @Override
    public MutableDistributionState getDistributionState() {
        return this.distributionState;
    }

    @Override
    public MutableMigrationState getMigrationState() {
        return this.mutableMigrationState;
    }

    @Override
    public MutableUserTaskState getUserTaskState() {
        return this.userTaskState;
    }

    @Override
    public MutableCompensationSubscriptionState getCompensationSubscriptionState() {
        return this.compensationSubscriptionState;
    }

    @Override
    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    @Override
    public PendingMessageSubscriptionState getPendingMessageSubscriptionState() {
        return this.messageSubscriptionState;
    }

    @Override
    public PendingProcessMessageSubscriptionState getPendingProcessMessageSubscriptionState() {
        return this.processMessageSubscriptionState;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public boolean isEmpty(ZbColumnFamilies column) {
        TransactionContext newContext = this.zeebeDb.createContext();
        return this.zeebeDb.isEmpty(column, newContext);
    }

    public <KeyType extends DbKey, ValueType extends DbValue> void forEach(ZbColumnFamilies columnFamily, KeyType keyInstance, ValueType valueInstance, BiConsumer<KeyType, ValueType> visitor) {
        TransactionContext newContext = this.zeebeDb.createContext();
        this.zeebeDb.createColumnFamily(columnFamily, newContext, keyInstance, valueInstance).forEach(visitor);
    }
}

