/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.analyzers;

import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;

public final class CatchEventAnalyzer {
    private static final Comparator<ExecutableCatchEvent> ERROR_CODE_COMPARATOR = Comparator.comparing(catchEvent -> catchEvent.getError().getErrorCode().get()).reversed();
    private static final Comparator<ExecutableCatchEvent> ESCALATION_CODE_COMPARATOR = Comparator.comparing(catchEvent -> catchEvent.getEscalation().getEscalationCode().get()).reversed();
    private final CatchEventTuple catchEventTuple = new CatchEventTuple();
    private final ProcessState processState;
    private final ElementInstanceState elementInstanceState;

    public CatchEventAnalyzer(ProcessState processState, ElementInstanceState elementInstanceState) {
        this.processState = processState;
        this.elementInstanceState = elementInstanceState;
    }

    public Either<Failure, CatchEventTuple> findErrorCatchEvent(DirectBuffer errorCode, ElementInstance instance, Optional<DirectBuffer> jobErrorMessage) {
        ArrayList availableCatchEvents = new ArrayList();
        while (instance != null && instance.isActive()) {
            ProcessInstanceRecord instanceRecord = instance.getValue();
            ExecutableProcess process = this.getProcess(instanceRecord.getProcessDefinitionKey(), instanceRecord.getTenantId());
            Either<List<DirectBuffer>, CatchEventTuple> found = this.findErrorCatchEventInProcess(errorCode, process, instance);
            if (found.isRight()) {
                return Either.right(found.get());
            }
            availableCatchEvents.addAll(found.getLeft());
            long parentElementInstanceKey = instanceRecord.getParentElementInstanceKey();
            instance = this.elementInstanceState.getInstance(parentElementInstanceKey);
        }
        String incidentErrorMessage = String.format("Expected to throw an error event with the code '%s'%s, but it was not caught.%s", BufferUtil.bufferAsString(errorCode), jobErrorMessage.isPresent() && jobErrorMessage.get().capacity() > 0 ? String.format(" with message '%s'", BufferUtil.bufferAsString(jobErrorMessage.get())) : "", availableCatchEvents.isEmpty() ? " No error events are available in the scope." : String.format(" Available error events are [%s]", availableCatchEvents.stream().map(BufferUtil::bufferAsString).collect(Collectors.joining(", "))));
        return Either.left(new Failure(incidentErrorMessage, ErrorType.UNHANDLED_ERROR_EVENT));
    }

    private Either<List<DirectBuffer>, CatchEventTuple> findErrorCatchEventInProcess(DirectBuffer errorCode, ExecutableProcess process, ElementInstance instance) {
        Either<List<DirectBuffer>, CatchEventTuple> availableCatchEvents = Either.left(new ArrayList());
        while (instance != null && instance.isActive() && !instance.isInterrupted()) {
            Either<List<DirectBuffer>, CatchEventTuple> found = this.findErrorCatchEventInScope(errorCode, process, instance);
            if (found.isRight()) {
                return found;
            }
            availableCatchEvents.getLeft().addAll((Collection<DirectBuffer>)found.getLeft());
            long instanceParentKey = instance.getParentKey();
            instance = this.elementInstanceState.getInstance(instanceParentKey);
        }
        return availableCatchEvents;
    }

    private Either<List<DirectBuffer>, CatchEventTuple> findErrorCatchEventInScope(DirectBuffer errorCode, ExecutableProcess process, ElementInstance instance) {
        BpmnElementType elementType;
        Either<List<DirectBuffer>, CatchEventTuple> availableCatchEvents = Either.left(new ArrayList());
        ProcessInstanceRecord processInstanceRecord = instance.getValue();
        DirectBuffer elementId = processInstanceRecord.getElementIdBuffer();
        ExecutableActivity element = process.getElementById(elementId, elementType = processInstanceRecord.getBpmnElementType(), ExecutableActivity.class);
        Optional<ExecutableCatchEvent> errorCatchEvent = element.getEvents().stream().filter(ExecutableCatchEvent::isError).filter(catchEvent -> catchEvent.getError().getErrorCode().isPresent()).sorted(ERROR_CODE_COMPARATOR).filter(event -> this.matchesErrorCode((ExecutableCatchEvent)event, errorCode, availableCatchEvents)).findFirst();
        if (errorCatchEvent.isPresent()) {
            this.catchEventTuple.instance = instance;
            this.catchEventTuple.catchEvent = errorCatchEvent.get();
            return Either.right(this.catchEventTuple);
        }
        return availableCatchEvents;
    }

    private boolean matchesErrorCode(ExecutableCatchEvent catchEvent, DirectBuffer errorCode, Either<List<DirectBuffer>, CatchEventTuple> availableCatchEvents) {
        DirectBuffer eventErrorCode = catchEvent.getError().getErrorCode().get();
        availableCatchEvents.getLeft().add(eventErrorCode);
        return eventErrorCode.capacity() == 0 || eventErrorCode.equals(errorCode);
    }

    public Optional<CatchEventTuple> findEscalationCatchEvent(DirectBuffer escalationCode, ElementInstance instance) {
        ProcessInstanceRecord instanceRecord = instance.getValue();
        ExecutableProcess process = this.getProcess(instanceRecord.getProcessDefinitionKey(), instanceRecord.getTenantId());
        return this.findEscalationCatchEventInProcess(escalationCode, process, instance).or(() -> {
            ElementInstance parentElementInstance = this.elementInstanceState.getInstance(instanceRecord.getParentElementInstanceKey());
            if (parentElementInstance != null && parentElementInstance.isActive()) {
                return this.findEscalationCatchEvent(escalationCode, parentElementInstance);
            }
            return Optional.empty();
        });
    }

    private Optional<CatchEventTuple> findEscalationCatchEventInProcess(DirectBuffer escalationCode, ExecutableProcess process, ElementInstance instance) {
        return this.findEscalationCatchEventInScope(escalationCode, process, instance).or(() -> {
            ElementInstance parentElementInstance = this.elementInstanceState.getInstance(instance.getParentKey());
            if (parentElementInstance != null && instance.isActive() && !instance.isInterrupted()) {
                return this.findEscalationCatchEventInProcess(escalationCode, process, parentElementInstance);
            }
            return Optional.empty();
        });
    }

    private Optional<CatchEventTuple> findEscalationCatchEventInScope(DirectBuffer escalationCode, ExecutableProcess process, ElementInstance instance) {
        BpmnElementType elementType;
        ProcessInstanceRecord processInstanceRecord = instance.getValue();
        DirectBuffer elementId = processInstanceRecord.getElementIdBuffer();
        ExecutableActivity element = process.getElementById(elementId, elementType = processInstanceRecord.getBpmnElementType(), ExecutableActivity.class);
        Optional<ExecutableCatchEvent> escalationCatchEvent = element.getEvents().stream().filter(ExecutableCatchEvent::isEscalation).filter(catchEvent -> catchEvent.getEscalation().getEscalationCode().isPresent()).sorted(ESCALATION_CODE_COMPARATOR).filter(event -> this.matchesEscalationCode((ExecutableCatchEvent)event, escalationCode)).findFirst();
        if (escalationCatchEvent.isPresent()) {
            this.catchEventTuple.instance = instance;
            this.catchEventTuple.catchEvent = escalationCatchEvent.get();
            return Optional.of(this.catchEventTuple);
        }
        return Optional.empty();
    }

    public boolean matchesEscalationCode(ExecutableCatchEvent catchEvent, DirectBuffer escalationCode) {
        DirectBuffer eventEscalationCode = catchEvent.getEscalation().getEscalationCode().get();
        return eventEscalationCode.capacity() == 0 || eventEscalationCode.equals(escalationCode);
    }

    private ExecutableProcess getProcess(long processDefinitionKey, String tenantId) {
        DeployedProcess deployedProcess = this.processState.getProcessByKeyAndTenant(processDefinitionKey, tenantId);
        if (deployedProcess == null) {
            throw new IllegalStateException(String.format("Expected process with key '%d' to be deployed but not found", processDefinitionKey));
        }
        return deployedProcess.getProcess();
    }

    public static final class CatchEventTuple {
        private ExecutableCatchEvent catchEvent;
        private ElementInstance instance;

        public ExecutableCatchEvent getCatchEvent() {
            return this.catchEvent;
        }

        public ElementInstance getElementInstance() {
            return this.instance;
        }
    }
}

