/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbInt;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.state.deployment.DeploymentRaw;
import io.camunda.zeebe.engine.state.immutable.DeploymentState;
import io.camunda.zeebe.engine.state.mutable.MutableDeploymentState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.collections.MutableBoolean;
import org.agrona.collections.MutableLong;
import org.agrona.collections.MutableReference;
import org.slf4j.Logger;

public final class DbDeploymentState
implements MutableDeploymentState {
    private static final Logger LOG = Loggers.STREAM_PROCESSING;
    private final DbLong deploymentKey = new DbLong();
    private final DbInt partitionKey = new DbInt();
    private final DbCompositeKey<DbLong, DbInt> deploymentPartitionKey = new DbCompositeKey<DbLong, DbInt>(this.deploymentKey, this.partitionKey);
    private final ColumnFamily<DbCompositeKey<DbLong, DbInt>, DbNil> pendingDeploymentColumnFamily;
    private final DeploymentRaw deploymentRaw;
    private final ColumnFamily<DbLong, DeploymentRaw> deploymentRawColumnFamily;

    public DbDeploymentState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.pendingDeploymentColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.PENDING_DEPLOYMENT, transactionContext, this.deploymentPartitionKey, DbNil.INSTANCE);
        this.deploymentRaw = new DeploymentRaw();
        this.deploymentRawColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.DEPLOYMENT_RAW, transactionContext, this.deploymentKey, this.deploymentRaw);
    }

    @Override
    public void addPendingDeploymentDistribution(long deploymentKey, int partition) {
        this.deploymentKey.wrapLong(deploymentKey);
        this.partitionKey.wrapInt(partition);
        this.pendingDeploymentColumnFamily.insert(this.deploymentPartitionKey, DbNil.INSTANCE);
    }

    @Override
    public void removePendingDeploymentDistribution(long deploymentKey, int partition) {
        this.deploymentKey.wrapLong(deploymentKey);
        this.partitionKey.wrapInt(partition);
        this.pendingDeploymentColumnFamily.deleteExisting(this.deploymentPartitionKey);
    }

    @Override
    public void storeDeploymentRecord(long key, DeploymentRecord value) {
        this.deploymentKey.wrapLong(key);
        this.deploymentRaw.setDeploymentRecord(value);
        this.deploymentRawColumnFamily.insert(this.deploymentKey, this.deploymentRaw);
    }

    @Override
    public void removeDeploymentRecord(long key) {
        this.deploymentKey.wrapLong(key);
        this.deploymentRawColumnFamily.deleteIfExists(this.deploymentKey);
    }

    @Override
    public boolean hasPendingDeploymentDistribution(long deploymentKey) {
        this.deploymentKey.wrapLong(deploymentKey);
        MutableBoolean hasPending = new MutableBoolean();
        this.pendingDeploymentColumnFamily.whileEqualPrefix((DbKey)this.deploymentKey, (dbLongDbIntDbCompositeKey, dbNil) -> {
            hasPending.set(true);
            return false;
        });
        return hasPending.get();
    }

    @Override
    public boolean hasPendingDeploymentDistribution(long deploymentKey, int partitionId) {
        this.deploymentKey.wrapLong(deploymentKey);
        this.partitionKey.wrapInt(partitionId);
        return this.pendingDeploymentColumnFamily.exists(this.deploymentPartitionKey);
    }

    @Override
    public DeploymentRecord getStoredDeploymentRecord(long key) {
        this.deploymentKey.wrapLong(key);
        DeploymentRaw storedDeploymentRaw = this.deploymentRawColumnFamily.get(this.deploymentKey);
        DeploymentRecord record = null;
        if (storedDeploymentRaw != null) {
            record = storedDeploymentRaw.getDeploymentRecord();
        }
        return record;
    }

    @Override
    public void foreachPendingDeploymentDistribution(DeploymentState.PendingDeploymentVisitor pendingDeploymentVisitor) {
        MutableReference lastDeployment = new MutableReference();
        MutableLong lastDeploymentKey = new MutableLong(0L);
        this.pendingDeploymentColumnFamily.forEach((compositeKey, nil) -> {
            long deploymentKey = ((DbLong)compositeKey.first()).getValue();
            int partitionId = ((DbInt)compositeKey.second()).getValue();
            if (lastDeploymentKey.value != deploymentKey) {
                DeploymentRaw deploymentRaw = this.deploymentRawColumnFamily.get((DbLong)compositeKey.first());
                if (deploymentRaw == null) {
                    LOG.warn("Expected to find a deployment with key {} for a pending partition {}, but none found. The state is inconsistent.", (Object)deploymentKey, (Object)partitionId);
                    return;
                }
                deploymentRaw.getDeploymentRecord().setTenantId("<default>");
                lastDeployment.set(BufferUtil.createCopy(deploymentRaw.getDeploymentRecord()));
                lastDeploymentKey.set(deploymentKey);
            }
            pendingDeploymentVisitor.visit(deploymentKey, partitionId, (DirectBuffer)lastDeployment.get());
        });
    }
}

