/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.BinaryProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.record.value.deployment.FormRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class PersistedForm
extends UnpackedObject
implements DbValue {
    private final StringProperty formIdProp = new StringProperty("formId");
    private final IntegerProperty versionProp = new IntegerProperty("version");
    private final LongProperty formKeyProp = new LongProperty("formKey");
    private final StringProperty resourceNameProp = new StringProperty("resourceName");
    private final BinaryProperty resourceProp = new BinaryProperty("resource", new UnsafeBuffer());
    private final BinaryProperty checksumProp = new BinaryProperty("checksum", new UnsafeBuffer());
    private final StringProperty tenantIdProp = new StringProperty("tenantId", "<default>");

    public PersistedForm() {
        super(7);
        this.declareProperty(this.formIdProp).declareProperty(this.versionProp).declareProperty(this.formKeyProp).declareProperty(this.resourceNameProp).declareProperty(this.resourceProp).declareProperty(this.checksumProp).declareProperty(this.tenantIdProp);
    }

    public PersistedForm copy() {
        PersistedForm copy = new PersistedForm();
        copy.formIdProp.setValue(BufferUtil.cloneBuffer(this.getFormId()));
        copy.versionProp.setValue(this.getVersion());
        copy.formKeyProp.setValue(this.getFormKey());
        copy.resourceNameProp.setValue(BufferUtil.cloneBuffer(this.getResourceName()));
        copy.resourceProp.setValue(BufferUtil.cloneBuffer(this.getResource()));
        copy.checksumProp.setValue(BufferUtil.cloneBuffer(this.getChecksum()));
        copy.tenantIdProp.setValue(this.getTenantId());
        return copy;
    }

    public DirectBuffer getFormId() {
        return this.formIdProp.getValue();
    }

    public int getVersion() {
        return this.versionProp.getValue();
    }

    public long getFormKey() {
        return this.formKeyProp.getValue();
    }

    public DirectBuffer getResourceName() {
        return this.resourceNameProp.getValue();
    }

    public DirectBuffer getResource() {
        return this.resourceProp.getValue();
    }

    public DirectBuffer getChecksum() {
        return this.checksumProp.getValue();
    }

    public String getTenantId() {
        return BufferUtil.bufferAsString(this.tenantIdProp.getValue());
    }

    public void wrap(FormRecord record) {
        this.formIdProp.setValue(record.getFormId());
        this.versionProp.setValue(record.getVersion());
        this.formKeyProp.setValue(record.getFormKey());
        this.resourceNameProp.setValue(record.getResourceNameBuffer());
        this.resourceProp.setValue(BufferUtil.wrapArray(record.getResource()));
        this.checksumProp.setValue(record.getChecksumBuffer());
        this.tenantIdProp.setValue(record.getTenantId());
    }
}

