/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.instance.JobRecordValue;
import io.camunda.zeebe.engine.state.instance.JobStateValue;
import io.camunda.zeebe.engine.state.mutable.MutableJobState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.util.EnsureUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.agrona.DirectBuffer;
import org.agrona.collections.LongHashSet;
import org.slf4j.Logger;

public final class DbJobState
implements JobState,
MutableJobState {
    private static final Logger LOG = Loggers.PROCESS_PROCESSOR_LOGGER;
    private final JobRecordValue jobRecordToRead = new JobRecordValue();
    private final JobRecordValue jobRecordToWrite = new JobRecordValue();
    private final DbLong jobKey;
    private final DbForeignKey<DbLong> fkJob;
    private final ColumnFamily<DbLong, JobRecordValue> jobsColumnFamily;
    private final JobStateValue jobState = new JobStateValue();
    private final ColumnFamily<DbForeignKey<DbLong>, JobStateValue> statesJobColumnFamily;
    private final DbString jobTypeKey;
    private final DbString tenantIdKey;
    private final DbCompositeKey<DbString, DbForeignKey<DbLong>> typeJobKey;
    private final DbTenantAwareKey<DbCompositeKey<DbString, DbForeignKey<DbLong>>> tenantAwareTypeJobKey;
    private final ColumnFamily<DbTenantAwareKey<DbCompositeKey<DbString, DbForeignKey<DbLong>>>, DbNil> activatableColumnFamily;
    private final DbLong deadlineKey;
    private final DbCompositeKey<DbLong, DbForeignKey<DbLong>> deadlineJobKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbForeignKey<DbLong>>, DbNil> deadlinesColumnFamily;
    private final DbLong backoffKey;
    private final DbCompositeKey<DbLong, DbForeignKey<DbLong>> backoffJobKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbForeignKey<DbLong>>, DbNil> backoffColumnFamily;
    private long nextBackOffDueDate;

    public DbJobState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.jobKey = new DbLong();
        this.fkJob = new DbForeignKey<DbLong>(this.jobKey, ZbColumnFamilies.JOBS);
        this.jobsColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.JOBS, transactionContext, this.jobKey, this.jobRecordToRead);
        this.statesJobColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.JOB_STATES, transactionContext, this.fkJob, this.jobState);
        this.jobTypeKey = new DbString();
        this.tenantIdKey = new DbString();
        this.typeJobKey = new DbCompositeKey<DbString, DbForeignKey<DbLong>>(this.jobTypeKey, this.fkJob);
        this.tenantAwareTypeJobKey = new DbTenantAwareKey<DbCompositeKey<DbString, DbForeignKey<DbLong>>>(this.tenantIdKey, this.typeJobKey, DbTenantAwareKey.PlacementType.SUFFIX);
        this.activatableColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.JOB_ACTIVATABLE, transactionContext, this.tenantAwareTypeJobKey, DbNil.INSTANCE);
        this.deadlineKey = new DbLong();
        this.deadlineJobKey = new DbCompositeKey<DbLong, DbForeignKey<DbLong>>(this.deadlineKey, this.fkJob);
        this.deadlinesColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.JOB_DEADLINES, transactionContext, this.deadlineJobKey, DbNil.INSTANCE);
        this.backoffKey = new DbLong();
        this.backoffJobKey = new DbCompositeKey<DbLong, DbForeignKey<DbLong>>(this.backoffKey, this.fkJob);
        this.backoffColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.JOB_BACKOFF, transactionContext, this.backoffJobKey, DbNil.INSTANCE);
    }

    @Override
    public void create(long key, JobRecord record) {
        DirectBuffer type = record.getTypeBuffer();
        this.createJob(key, record, type);
    }

    @Override
    public void activate(long key, JobRecord record) {
        DirectBuffer type = record.getTypeBuffer();
        String tenantId = record.getTenantId();
        long deadline = record.getDeadline();
        this.validateParameters(type);
        EnsureUtil.ensureGreaterThan("deadline", deadline, 0L);
        this.updateJobRecord(key, record);
        this.updateJobState(JobState.State.ACTIVATED);
        this.makeJobNotActivatable(type, tenantId);
        this.addJobDeadline(key, deadline);
    }

    @Override
    public void recurAfterBackoff(long key, JobRecord record) {
        this.updateJob(key, record, JobState.State.ACTIVATABLE);
        this.removeJobBackoff(key, record.getRecurringTime());
    }

    @Override
    public void timeout(long key, JobRecord record) {
        DirectBuffer type = record.getTypeBuffer();
        long deadline = record.getDeadline();
        this.validateParameters(type);
        EnsureUtil.ensureGreaterThan("deadline", deadline, 0L);
        this.updateJob(key, record, JobState.State.ACTIVATABLE);
    }

    @Override
    public void complete(long key, JobRecord record) {
        this.delete(key, record);
    }

    @Override
    public void cancel(long key, JobRecord record) {
        this.delete(key, record);
    }

    @Override
    public void disable(long key, JobRecord record) {
        this.updateJob(key, record, JobState.State.FAILED);
        this.makeJobNotActivatable(record.getTypeBuffer(), record.getTenantId());
    }

    @Override
    public void throwError(long key, JobRecord updatedValue) {
        this.updateJob(key, updatedValue, JobState.State.ERROR_THROWN);
        this.makeJobNotActivatable(updatedValue.getTypeBuffer(), updatedValue.getTenantId());
    }

    @Override
    public void delete(long key, JobRecord record) {
        DirectBuffer type = record.getTypeBuffer();
        String tenantId = record.getTenantId();
        this.jobKey.wrapLong(key);
        this.jobsColumnFamily.deleteExisting(this.jobKey);
        this.statesJobColumnFamily.deleteExisting(this.fkJob);
        this.makeJobNotActivatable(type, tenantId);
        this.removeJobDeadline(key, record.getDeadline());
        this.removeJobBackoff(key, record.getRecurringTime());
    }

    @Override
    public void fail(long key, JobRecord updatedValue) {
        if (updatedValue.getRetries() > 0) {
            if (updatedValue.getRetryBackoff() > 0L) {
                this.addJobBackoff(key, updatedValue.getRecurringTime());
                this.updateJob(key, updatedValue, JobState.State.FAILED);
                this.makeJobNotActivatable(updatedValue.getTypeBuffer(), updatedValue.getTenantId());
            } else {
                this.updateJob(key, updatedValue, JobState.State.ACTIVATABLE);
            }
        } else {
            this.updateJob(key, updatedValue, JobState.State.FAILED);
            this.makeJobNotActivatable(updatedValue.getTypeBuffer(), updatedValue.getTenantId());
        }
    }

    @Override
    public void yield(long key, JobRecord updatedValue) {
        this.updateJob(key, updatedValue, JobState.State.ACTIVATABLE);
    }

    @Override
    public void resolve(long key, JobRecord updatedValue) {
        this.updateJob(key, updatedValue, JobState.State.ACTIVATABLE);
    }

    @Override
    public JobRecord updateJobRetries(long jobKey, int retries) {
        JobRecord job = this.getJob(jobKey);
        if (job != null) {
            job.setRetries(retries);
            this.updateJobRecord(jobKey, job);
        }
        return job;
    }

    @Override
    public void cleanupTimeoutsWithoutJobs() {
        this.deadlinesColumnFamily.whileTrue((key, value) -> {
            DbLong jobKey = (DbLong)((DbForeignKey)key.second()).inner();
            long deadline = ((DbLong)key.first()).getValue();
            JobRecordValue job = this.jobsColumnFamily.get(jobKey);
            if (job == null || job.getRecord().getDeadline() != deadline) {
                this.deadlinesColumnFamily.deleteExisting((DbCompositeKey<DbLong, DbForeignKey<DbLong>>)key);
            }
            return true;
        });
    }

    @Override
    public void cleanupBackoffsWithoutJobs() {
        this.backoffColumnFamily.whileTrue((key, value) -> {
            DbLong jobKey = (DbLong)((DbForeignKey)key.second()).inner();
            long backoff = ((DbLong)key.first()).getValue();
            JobRecordValue job = this.jobsColumnFamily.get(jobKey);
            if (job == null || job.getRecord().getRecurringTime() != backoff) {
                LOG.debug("Deleting orphaned job with key {}", (Object)key);
                this.backoffColumnFamily.deleteExisting((DbCompositeKey<DbLong, DbForeignKey<DbLong>>)key);
            }
            return true;
        });
    }

    @Override
    public void updateJobDeadline(long jobKey, long newDeadline) {
        this.jobKey.wrapLong(jobKey);
        JobRecord job = this.getJob(jobKey);
        if (job != null) {
            long oldDeadline = job.getDeadline();
            this.deadlineKey.wrapLong(oldDeadline);
            this.deadlinesColumnFamily.deleteExisting(this.deadlineJobKey);
            job.setDeadline(newDeadline);
            this.updateJobRecord(jobKey, job);
            this.addJobDeadline(jobKey, newDeadline);
        }
    }

    @Override
    public void migrate(long key, JobRecord record) {
        this.updateJobRecord(key, record);
    }

    @Override
    public void restoreBackoff() {
        LongHashSet jobsWithBackoff = new LongHashSet();
        this.backoffColumnFamily.forEach((key, value) -> {
            JobRecordValue jobRecord = this.jobsColumnFamily.get(this.jobKey);
            if (jobRecord == null || jobRecord.getRecord().getRetries() <= 0 || jobRecord.getRecord().getRetryBackoff() <= 0L) {
                this.backoffColumnFamily.deleteExisting((DbCompositeKey<DbLong, DbForeignKey<DbLong>>)key);
            } else {
                jobsWithBackoff.add(this.jobKey.getValue());
            }
        });
        this.statesJobColumnFamily.forEach(value -> {
            if (!JobState.State.FAILED.equals((Object)value.getState())) {
                return;
            }
            if (jobsWithBackoff.contains(this.jobKey.getValue())) {
                return;
            }
            JobRecordValue jobRecord = this.jobsColumnFamily.get(this.jobKey);
            long backoff = jobRecord.getRecord().getRecurringTime();
            int retries = jobRecord.getRecord().getRetries();
            if (backoff > 0L && retries > 0) {
                this.backoffKey.wrapLong(backoff);
                this.backoffColumnFamily.insert(this.backoffJobKey, DbNil.INSTANCE);
            }
        });
    }

    private void createJob(long key, JobRecord record, DirectBuffer type) {
        this.createJobRecord(key, record);
        this.initializeJobState();
        this.makeJobActivatable(type, key, record.getTenantId());
    }

    private void updateJob(long key, JobRecord updatedValue, JobState.State newState) {
        DirectBuffer type = updatedValue.getTypeBuffer();
        this.validateParameters(type);
        this.updateJobRecord(key, updatedValue);
        this.updateJobState(newState);
        if (newState == JobState.State.ACTIVATABLE) {
            this.makeJobActivatable(type, key, updatedValue.getTenantId());
        }
        if (newState != JobState.State.ACTIVATED) {
            this.removeJobDeadline(key, updatedValue.getDeadline());
        }
    }

    private void validateParameters(DirectBuffer type) {
        EnsureUtil.ensureNotNullOrEmpty("type", type);
    }

    @Override
    public JobState.DeadlineIndex forEachTimedOutEntry(long executionTimestamp, JobState.DeadlineIndex startAt, BiPredicate<Long, JobRecord> callback) {
        DbCompositeKey<DbLong, DbForeignKey<DbLong>> startAtKey;
        if (startAt != null) {
            this.deadlineKey.wrapLong(startAt.deadline());
            this.jobKey.wrapLong(startAt.key());
            startAtKey = this.deadlineJobKey;
        } else {
            startAtKey = null;
        }
        AtomicReference lastVisitedIndex = new AtomicReference();
        this.deadlinesColumnFamily.whileTrue(startAtKey, (key, value) -> {
            boolean isDue;
            long deadline = ((DbLong)key.first()).getValue();
            boolean bl = isDue = deadline < executionTimestamp;
            if (!isDue) {
                return false;
            }
            long jobKey = ((DbLong)((DbForeignKey)key.second()).inner()).getValue();
            if (!this.visitJob(jobKey, callback)) {
                lastVisitedIndex.set(new JobState.DeadlineIndex(((DbLong)key.first()).getValue(), ((DbLong)((DbForeignKey)key.second()).inner()).getValue()));
                return false;
            }
            return true;
        });
        return (JobState.DeadlineIndex)lastVisitedIndex.get();
    }

    @Override
    public boolean exists(long jobKey) {
        this.jobKey.wrapLong(jobKey);
        return this.jobsColumnFamily.exists(this.jobKey);
    }

    @Override
    public JobState.State getState(long key) {
        this.jobKey.wrapLong(key);
        JobStateValue storedState = this.statesJobColumnFamily.get(this.fkJob);
        if (storedState == null) {
            return JobState.State.NOT_FOUND;
        }
        return storedState.getState();
    }

    @Override
    public boolean isInState(long key, JobState.State state) {
        return this.getState(key) == state;
    }

    @Override
    public void forEachActivatableJobs(DirectBuffer type, List<String> tenantIds, BiFunction<Long, JobRecord, Boolean> callback) {
        this.jobTypeKey.wrapBuffer(type);
        this.activatableColumnFamily.whileEqualPrefix((DbKey)this.jobTypeKey, (tenantAwareCompositeKey, zbNil) -> {
            DbLong jobKey = (DbLong)((DbForeignKey)((DbCompositeKey)tenantAwareCompositeKey.wrappedKey()).second()).inner();
            String tenantId = tenantAwareCompositeKey.tenantKey().toString();
            if (tenantIds.contains(tenantId)) {
                return this.visitJob(jobKey.getValue(), callback::apply);
            }
            return true;
        });
    }

    @Override
    public JobRecord getJob(long key) {
        this.jobKey.wrapLong(key);
        JobRecordValue jobState = this.jobsColumnFamily.get(this.jobKey);
        return jobState == null ? null : jobState.getRecord();
    }

    @Override
    public JobRecord getJob(long key, Map<String, Object> authorizations) {
        JobRecord jobRecord = this.getJob(key);
        if (jobRecord != null && this.getAuthorizedTenantIds(authorizations).contains(jobRecord.getTenantId())) {
            return jobRecord;
        }
        return null;
    }

    @Override
    public boolean jobDeadlineExists(long jobKey, long deadline) {
        this.jobKey.wrapLong(jobKey);
        this.deadlineKey.wrapLong(deadline);
        return this.deadlinesColumnFamily.exists(this.deadlineJobKey);
    }

    @Override
    public long findBackedOffJobs(long timestamp, BiPredicate<Long, JobRecord> callback) {
        this.nextBackOffDueDate = -1L;
        this.backoffColumnFamily.whileTrue((key, value) -> {
            long deadline = ((DbLong)key.first()).getValue();
            boolean consumed = false;
            if (deadline <= timestamp) {
                long jobKey = ((DbLong)((DbForeignKey)key.second()).inner()).getValue();
                consumed = this.visitJob(jobKey, callback);
            }
            if (!consumed) {
                this.nextBackOffDueDate = deadline;
            }
            return consumed;
        });
        return this.nextBackOffDueDate;
    }

    boolean visitJob(long jobKey, BiPredicate<Long, JobRecord> callback) {
        JobRecord job = this.getJob(jobKey);
        if (job == null) {
            LOG.warn("Expected to find job with key {}, but no job found", (Object)jobKey);
            return true;
        }
        return callback.test(jobKey, job);
    }

    private void createJobRecord(long key, JobRecord record) {
        this.jobKey.wrapLong(key);
        this.jobRecordToWrite.setRecordWithoutVariables(record);
        this.jobsColumnFamily.insert(this.jobKey, this.jobRecordToWrite);
    }

    private void updateJobRecord(long key, JobRecord updatedValue) {
        this.jobKey.wrapLong(key);
        this.jobRecordToWrite.setRecordWithoutVariables(updatedValue);
        this.jobsColumnFamily.update(this.jobKey, this.jobRecordToWrite);
    }

    private void initializeJobState() {
        this.jobState.setState(JobState.State.ACTIVATABLE);
        this.statesJobColumnFamily.insert(this.fkJob, this.jobState);
    }

    private void updateJobState(JobState.State newState) {
        this.jobState.setState(newState);
        this.statesJobColumnFamily.update(this.fkJob, this.jobState);
    }

    private void makeJobActivatable(DirectBuffer type, long key, String tenantId) {
        EnsureUtil.ensureNotNullOrEmpty("type", type);
        EnsureUtil.ensureNotNullOrEmpty("tenantId", tenantId);
        this.jobTypeKey.wrapBuffer(type);
        this.jobKey.wrapLong(key);
        this.tenantIdKey.wrapString(tenantId);
        this.activatableColumnFamily.upsert(this.tenantAwareTypeJobKey, DbNil.INSTANCE);
    }

    private void makeJobNotActivatable(DirectBuffer type, String tenantId) {
        EnsureUtil.ensureNotNullOrEmpty("type", type);
        EnsureUtil.ensureNotNullOrEmpty("tenantid", tenantId);
        this.jobTypeKey.wrapBuffer(type);
        this.tenantIdKey.wrapString(tenantId);
        this.activatableColumnFamily.deleteIfExists(this.tenantAwareTypeJobKey);
    }

    private void addJobDeadline(long job, long deadline) {
        if (deadline > 0L) {
            this.jobKey.wrapLong(job);
            this.deadlineKey.wrapLong(deadline);
            this.deadlinesColumnFamily.insert(this.deadlineJobKey, DbNil.INSTANCE);
        }
    }

    private void removeJobDeadline(long job, long deadline) {
        if (deadline > 0L) {
            this.jobKey.wrapLong(job);
            this.deadlineKey.wrapLong(deadline);
            this.deadlinesColumnFamily.deleteIfExists(this.deadlineJobKey);
        }
    }

    private void addJobBackoff(long job, long backoff) {
        if (backoff > 0L) {
            this.jobKey.wrapLong(job);
            this.backoffKey.wrapLong(backoff);
            this.backoffColumnFamily.insert(this.backoffJobKey, DbNil.INSTANCE);
        }
    }

    private void removeJobBackoff(long job, long backoff) {
        if (backoff > 0L) {
            this.jobKey.wrapLong(job);
            this.backoffKey.wrapLong(backoff);
            this.backoffColumnFamily.deleteIfExists(this.backoffJobKey);
        }
    }

    private List<String> getAuthorizedTenantIds(Map<String, Object> authorizations) {
        return (List)authorizations.get("authorized_tenants");
    }
}

