/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.engine.state.immutable.TimerInstanceState;
import io.camunda.zeebe.engine.state.instance.TimerInstance;
import io.camunda.zeebe.engine.state.mutable.MutableTimerInstanceState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import java.util.function.Consumer;

public final class DbTimerInstanceState
implements MutableTimerInstanceState {
    private final ColumnFamily<DbCompositeKey<DbForeignKey<DbLong>, DbLong>, TimerInstance> timerInstanceColumnFamily;
    private final TimerInstance timerInstance = new TimerInstance();
    private final DbLong timerKey = new DbLong();
    private final DbForeignKey<DbLong> elementInstanceKey = new DbForeignKey<DbLong>(new DbLong(), ZbColumnFamilies.ELEMENT_INSTANCE_KEY, DbForeignKey.MatchType.Full, k -> k.getValue() == -1L);
    private final DbCompositeKey<DbForeignKey<DbLong>, DbLong> elementAndTimerKey = new DbCompositeKey<DbForeignKey<DbLong>, DbLong>(this.elementInstanceKey, this.timerKey);
    private final ColumnFamily<DbCompositeKey<DbLong, DbCompositeKey<DbForeignKey<DbLong>, DbLong>>, DbNil> dueDateColumnFamily;
    private final DbLong dueDate;
    private final DbCompositeKey<DbLong, DbCompositeKey<DbForeignKey<DbLong>, DbLong>> dueDateCompositeKey;
    private long nextDueDate;

    public DbTimerInstanceState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.timerInstanceColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.TIMERS, transactionContext, this.elementAndTimerKey, this.timerInstance);
        this.dueDate = new DbLong();
        this.dueDateCompositeKey = new DbCompositeKey<DbLong, DbCompositeKey<DbForeignKey<DbLong>, DbLong>>(this.dueDate, this.elementAndTimerKey);
        this.dueDateColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.TIMER_DUE_DATES, transactionContext, this.dueDateCompositeKey, DbNil.INSTANCE);
    }

    @Override
    public void store(TimerInstance timer) {
        this.timerKey.wrapLong(timer.getKey());
        this.elementInstanceKey.inner().wrapLong(timer.getElementInstanceKey());
        this.timerInstanceColumnFamily.insert(this.elementAndTimerKey, timer);
        this.dueDate.wrapLong(timer.getDueDate());
        this.dueDateColumnFamily.insert(this.dueDateCompositeKey, DbNil.INSTANCE);
    }

    @Override
    public void remove(TimerInstance timer) {
        this.elementInstanceKey.inner().wrapLong(timer.getElementInstanceKey());
        this.timerKey.wrapLong(timer.getKey());
        this.timerInstanceColumnFamily.deleteExisting(this.elementAndTimerKey);
        this.dueDate.wrapLong(timer.getDueDate());
        this.dueDateColumnFamily.deleteExisting(this.dueDateCompositeKey);
    }

    @Override
    public long processTimersWithDueDateBefore(long timestamp, TimerInstanceState.TimerVisitor consumer) {
        this.nextDueDate = -1L;
        this.dueDateColumnFamily.whileTrue((key, nil) -> {
            long dueDate = ((DbLong)key.first()).getValue();
            DbCompositeKey elementAndTimerKey = (DbCompositeKey)key.second();
            boolean consumed = false;
            if (dueDate <= timestamp) {
                TimerInstance timerInstance = this.timerInstanceColumnFamily.get(elementAndTimerKey);
                if (timerInstance == null) {
                    return true;
                }
                consumed = consumer.visit(timerInstance);
            }
            if (!consumed) {
                this.nextDueDate = dueDate;
            }
            return consumed;
        });
        return this.nextDueDate;
    }

    @Override
    public void forEachTimerForElementInstance(long elementInstanceKey, Consumer<TimerInstance> action) {
        this.elementInstanceKey.inner().wrapLong(elementInstanceKey);
        this.timerInstanceColumnFamily.whileEqualPrefix(this.elementInstanceKey, (key, value) -> action.accept((TimerInstance)value));
    }

    @Override
    public TimerInstance get(long elementInstanceKey, long timerKey) {
        this.elementInstanceKey.inner().wrapLong(elementInstanceKey);
        this.timerKey.wrapLong(timerKey);
        return this.timerInstanceColumnFamily.get(this.elementAndTimerKey);
    }
}

