/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.EnumProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.ObjectProperty;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class IndexedRecord
extends UnpackedObject
implements DbValue {
    private final LongProperty keyProp = new LongProperty("key", 0L);
    private final EnumProperty<ProcessInstanceIntent> stateProp = new EnumProperty<ProcessInstanceIntent>("state", ProcessInstanceIntent.class);
    private final ObjectProperty<ProcessInstanceRecord> valueProp = new ObjectProperty<ProcessInstanceRecord>("processInstanceRecord", new ProcessInstanceRecord());

    IndexedRecord() {
        super(3);
        this.declareProperty(this.keyProp).declareProperty(this.stateProp).declareProperty(this.valueProp);
    }

    public IndexedRecord(long key, ProcessInstanceIntent instanceState, ProcessInstanceRecord record) {
        this();
        this.keyProp.setValue(key);
        this.stateProp.setValue(instanceState);
        this.setValue(record);
    }

    public long getKey() {
        return this.keyProp.getValue();
    }

    public IndexedRecord setKey(long key) {
        this.keyProp.setValue(key);
        return this;
    }

    public ProcessInstanceIntent getState() {
        return this.stateProp.getValue();
    }

    public IndexedRecord setState(ProcessInstanceIntent state) {
        this.stateProp.setValue(state);
        return this;
    }

    public boolean hasState(ProcessInstanceIntent state) {
        return this.getState() == state;
    }

    public ProcessInstanceRecord getValue() {
        return this.valueProp.getValue();
    }

    public IndexedRecord setValue(ProcessInstanceRecord value) {
        UnsafeBuffer valueBuffer = new UnsafeBuffer(0L, 0);
        int encodedLength = value.getLength();
        valueBuffer.wrap(new byte[encodedLength]);
        value.write(valueBuffer, 0);
        this.valueProp.getValue().wrap(valueBuffer, 0, encodedLength);
        return this;
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        byte[] bytes = new byte[length];
        UnsafeBuffer mutableBuffer = new UnsafeBuffer(bytes);
        buffer.getBytes(offset, bytes, 0, length);
        super.wrap(mutableBuffer, 0, length);
    }
}

